import {
  Body,
  Controller,
  Get,
  Param,
  Patch,
  Put,
  UseGuards,
} from '@nestjs/common';
import { AuthGuard } from '@nestjs/passport';
import { CheckPermissions } from 'src/auth/decorators/permissions.decorator';
import { Roles } from 'src/auth/decorators/roles.decorator';
import { PermissionsGuard } from 'src/auth/guards/permissions.guard';
import { RolesGuard } from 'src/auth/guards/roles.guard';
import { PermissionAction, UserRole } from 'src/enum';
import { UpdatePermissionDto } from './dto/permission.dto';
import { UserPermissionsService } from './user-permissions.service';
import { ApiOperation } from '@nestjs/swagger';

@Controller('user-permissions')
export class UserPermissionsController {
  constructor(
    private readonly userPermissionsService: UserPermissionsService,
  ) {}

  @Put(':id')
  @UseGuards(AuthGuard('jwt'), RolesGuard, PermissionsGuard)
  @Roles(...Object.values(UserRole))
  @CheckPermissions([PermissionAction.UPDATE, 'user_permission'])
  async update(@Param('id') id: string, @Body() dto: UpdatePermissionDto) {
    const obj = [];
    dto.menu.forEach((menuItem) => {
      menuItem.userPermission.forEach((permItem) => {
        obj.push({
          id: permItem.id,
          rootAccountId: permItem.accountId,
          menuId: menuItem.id,
          permissionId: permItem.permission.id,
          status: permItem.status,
        });
      });
    });
    this.userPermissionsService.create(obj);
    return { menu: dto.menu };
  }

  @Patch(':id')
  @ApiOperation({ summary: 'For Admin' })
  @UseGuards(AuthGuard('jwt'), RolesGuard, PermissionsGuard)
  @Roles(UserRole.BUSINESS)
  @CheckPermissions([PermissionAction.UPDATE, 'user_permission'])
  async permissionUpdate(
    @Param('id') id: string,
    @Body() dto: UpdatePermissionDto,
  ) {
    for (const i in dto.menu) {
      for (const j in dto.menu[i].userPermission) {
        await this.userPermissionsService.permissionUpdate(
          dto.menu[i].userPermission[j].accountId,
          dto.menu[i].userPermission[j].menuId,
          dto.menu[i].userPermission[j].permissionId,
          dto.menu[i].userPermission[j].status,
        );
      }
    }
    return this.userPermissionsService.findAll(id);
  }
}
