import { Module } from '@nestjs/common';
import { UserLogService } from './user-log.service';
import { UserLogController } from './user-log.controller';
import { TypeOrmModule } from '@nestjs/typeorm';
import { AuthModule } from 'src/auth/auth.module';
import { UserLog } from './entities/user-log.entity';
import { UserDetail } from 'src/user-details/entities/user-detail.entity';

@Module({
  imports: [TypeOrmModule.forFeature([UserLog, UserDetail]), AuthModule],
  controllers: [UserLogController],
  providers: [UserLogService],
})
export class UserLogModule {}
