import { Type } from 'class-transformer';
import {
  IsNotEmpty,
  IsNumber,
  IsOptional,
  IsString,
  IsUUID,
  Max,
  MaxLength,
  Min,
  MinLength,
} from 'class-validator';
import { MemberEntranceType } from 'src/enum';

export class CreateUserLogDto {
  @IsNotEmpty()
  @IsUUID()
  userDetailId: string;

  @IsOptional()
  name: string;

  @IsOptional()
  date: string;

  @IsOptional()
  entryTime: string;
}

export class LogPaginationDto {
  @IsNotEmpty()
  @Type(() => Number)
  @IsNumber()
  @Min(10)
  @Max(100)
  limit: number;

  @IsNotEmpty()
  @Type(() => Number)
  @IsNumber()
  @Min(0)
  offset: number;

  @IsOptional()
  @IsString()
  @MinLength(0)
  @MaxLength(100)
  keyword: string;

  @IsOptional()
  status: MemberEntranceType;

  @IsNotEmpty()
  @IsUUID()
  userDetailId: string;
}
