import { Type } from 'class-transformer';
import { IsNotEmpty, IsNumber, IsOptional, IsString, Max, MaxLength, Min, MinLength } from 'class-validator';
import { MemberStatus } from 'src/enum';

export class CreateUserChildDto {
  @IsNotEmpty()
  accountId: string;

  @IsOptional()
  businessAccId: string;

  @IsNotEmpty()
  @MinLength(2)
  @MaxLength(100)
  name: string;

  @IsNotEmpty()
  @MinLength(2)
  @MaxLength(100)
  email: string;

  @IsNotEmpty()
  @MinLength(10)
  @MaxLength(10)
  phoneNumber: string;

  @IsNotEmpty()
  relation: string;

  @IsNotEmpty()
  martialStatus: string;

  @IsNotEmpty()
  dob: string;

  @IsOptional()
  memberId: string;
}

export class CreateByUserChildDto {
  @IsOptional()
  accountId: string;

  @IsOptional()
  businessAccId: string;

  @IsNotEmpty()
  @MinLength(2)
  @MaxLength(100)
  name: string;

  @IsNotEmpty()
  @MinLength(2)
  @MaxLength(100)
  email: string;

  @IsNotEmpty()
  @MinLength(10)
  @MaxLength(10)
  phoneNumber: string;

  @IsNotEmpty()
  relation: string;

  @IsNotEmpty()
  martialStatus: string;

  @IsNotEmpty()
  dob: string;

  @IsOptional()
  memberId: string;

  @IsOptional()
  childCardNumber: string;
}

export class ChildPaginationDto {
  @IsNotEmpty()
  @Type(() => Number)
  @IsNumber()
  @Min(10)
  @Max(100)
  limit: number;

  @IsNotEmpty()
  @Type(() => Number)
  @IsNumber()
  @Min(0)
  offset: number;

  @IsOptional()
  @IsString()
  @MinLength(0)
  @MaxLength(100)
  keyword: string;

  @IsOptional()
  status: MemberStatus;

  @IsOptional()
  phoneNumber: string;

  @IsOptional()
  membershipType: string;

  @IsOptional()
  memberId: string;

  @IsOptional()
  startDate: string;

  @IsOptional()
  endDate: string;
}

export class CSVChildPaginationDto {
  @IsOptional()
  @IsString()
  @MinLength(0)
  @MaxLength(100)
  keyword: string;

  @IsOptional()
  status: MemberStatus;

  @IsOptional()
  phoneNumber: string;

  @IsOptional()
  membershipType: string;

  @IsOptional()
  memberId: string;

  @IsOptional()
  startDate: string;

  @IsOptional()
  endDate: string;
}

export class SearchChildDto{
  @IsNotEmpty()
  keyword: string;
}
