import {
  Controller,
  Get,
  Post,
  Body,
  Patch,
  Param,
  Delete,
  UseGuards,
} from '@nestjs/common';
import { PolicyMasterService } from './policy-master.service';
import { CreatePolicyMasterDto } from './dto/create-policy-master.dto';
import { UpdatePolicyMasterDto } from './dto/update-policy-master.dto';
import { AuthGuard } from '@nestjs/passport';
import { Roles } from 'src/auth/decorators/roles.decorator';
import { RolesGuard } from 'src/auth/guards/roles.guard';
import { UserRole } from 'src/enum';
import { CurrentUser } from 'src/auth/decorators/current-user.decorator';
import { Account } from 'src/account/entities/account.entity';

@Controller('policy-master')
export class PolicyMasterController {
  constructor(private readonly policyMasterService: PolicyMasterService) {}

  @Post()
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.ADMIN)
  create(@Body() dto: CreatePolicyMasterDto) {
    return this.policyMasterService.create(dto);
  }

  @Get('all/:accountId')
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.ADMIN)
  find(@Param('accountId') accountId: string) {
    return this.policyMasterService.find(accountId);
  }

  @Get('business-admin')
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.BUSINESS, UserRole.STAFF)
  findAll(@CurrentUser() user: Account) {
    return this.policyMasterService.find(user.id);
  }

  @Patch(':id')
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.ADMIN)
  update(@Param('id') id: string, @Body() dto: UpdatePolicyMasterDto) {
    return this.policyMasterService.update(id, dto);
  }

  @Delete(':id')
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.ADMIN)
  remove(@Param('id') id: string) {
    return this.policyMasterService.remove(id);
  }
}
