import { Injectable } from '@nestjs/common';
import { NotificationsService } from 'src/notifications/notifications.service';
// import { fcmMessanger } from 'src/utils/firebase-notify.utils';
import { sendSMS } from 'src/utils/sms.utils';

@Injectable()
export class NotifyService {
  constructor(private readonly notficationService: NotificationsService) {}

  userAccountApproved(phoneNumber: number, fcm: string, accountId: string) {
    const title = 'Account Approved';
    const message = 'Your account has been approved! Welcome to our stenry.';
    // Add logic to send notification using FCM with title and message
    // fcmMessanger(fcm, title, message);
    this.notficationService.create({
      title,
      desc: message,
      type: null,
      accountId,
    });
  }

  userPaymentFailed(
    phoneNumber: number,
    fcm: string,
    accountId: string,
    paymentId: string,
    total: number,
  ) {
    const title = 'Payment Failed';
    const message = `Your payment of ${total} for STNERY.com Tracking ID ${paymentId} has failed.In case your money has been debited, it will be refunded within 7-10 days.`;
    // Add logic to send notification using FCM with title and message
    // fcmMessanger(fcm, title, message);
    sendSMS(phoneNumber, message, 1707171929682221672);
    this.notficationService.create({
      title,
      desc: message,
      type: null,
      accountId,
    });
  }

  userAccountDisapproved(phoneNumber: number, fcm: string, accountId: string) {
    const title = 'Account Disapproved';
    const message =
      "We're sorry, but your account application has been disapproved. Please contact support for further assistance.";
    // Add logic to send notification using FCM with title and message
    // fcmMessanger(fcm, title, message);
    this.notficationService.create({
      title,
      desc: message,
      type: null,
      accountId,
    });
  }

  userAccountPending(phoneNumber: number, fcm: string, accountId: string) {
    const title = 'Account Pending';
    const message =
      'Dear Seller, Thank you for showing interest in our Seller Panel, We will verify your account & Share you update. STNERY';
    // Add logic to send notification using FCM with title and message
    // fcmMessanger(fcm, title, message);
    sendSMS(phoneNumber, message, 1707171929686254455);
    this.notficationService.create({
      title,
      desc: message,
      type: null,
      accountId,
    });
  }

  vendorAccountApproved(phoneNumber: string, fcm: string, accountId: string) {
    const title = 'Vendor Account Approved';
    const message =
      'Congratulations! Your vendor account has been approved. You can now start listing your products.';
    // Add logic to send notification using FCM with title and message
    // fcmMessanger(fcm, title, message);
    this.notficationService.create({
      title,
      desc: message,
      type: null,
      accountId,
    });
  }

  vendorAccountDisapproved(
    phoneNumber: number,
    fcm: string,
    accountId: string,
  ) {
    const title = 'Vendor Account Disapproved';
    const message =
      "We're sorry, but your vendor account application has been disapproved. Please contact support for more details.";
    // Add logic to send notification using FCM with title and message
    // fcmMessanger(fcm, title, message);
    this.notficationService.create({
      title,
      desc: message,
      type: null,
      accountId,
    });
  }

  vendorAccountPending(phoneNumber: number, fcm: string, accountId: string) {
    const title = 'Vendor Account Pending';
    const message =
      'Your vendor account application is currently pending. We will notify you once it has been reviewed.';
    // Add logic to send notification using FCM with title and message
    // fcmMessanger(fcm, title, message);
    this.notficationService.create({
      title,
      desc: message,
      type: null,
      accountId,
    });
  }
}
