import { IsEnum, IsNotEmpty, IsOptional } from 'class-validator';
import { NotificationType } from 'src/enum';

export class NotificationDto {
  @IsNotEmpty()
  title: string;

  @IsNotEmpty()
  desc: string;

  @IsOptional()
  @IsEnum(NotificationType)
  type: NotificationType;

  accountId: any;

  deviceId: any;
}

export class UpdateNotificationDto {
  @IsOptional()
  title: string;

  @IsOptional()
  desc: string;

  @IsOptional()
  type: NotificationType;

  accountId: any;

  deviceId: any;
}
