import { Injectable } from '@nestjs/common';
import { InjectRepository } from '@nestjs/typeorm';
import { Repository } from 'typeorm';
import { LoginHistory } from './entities/login-history.entity';
import { MasterPaginationDto, PaginationDto } from './dto/pagination.dto';

@Injectable()
export class LoginHistoryService {
  constructor(
    @InjectRepository(LoginHistory)
    private readonly repo: Repository<LoginHistory>,
  ) {}

  async findAll(dto: PaginationDto, accountId: string) {
    const [result, total] = await this.repo.findAndCount({
      where: { accountId },
      take: dto.limit,
      skip: dto.offset,
      order: { createdAt: 'DESC' },
    });
    return { result, total };
  }

  async findAllByMaster(dto: MasterPaginationDto, accountId: string) {
    const fromDate = new Date(dto.fromDate);
    fromDate.setHours(0, 0, 0, 0);

    const toDate = new Date(dto.toDate);
    toDate.setHours(23, 59, 59, 999);

    const query = await this.repo
      .createQueryBuilder('loginHistory')
      .where('loginHistory.accountId = :accountId', { accountId: accountId });
    if (dto.fromDate && dto.toDate) {
      query.andWhere(
        'loginHistory.createdAt >= :fromDate AND loginHistory.createdAt <= :toDate',
        {
          fromDate: fromDate,
          toDate: toDate,
        },
      );
    }
    const [result, total] = await query
      .orderBy({ 'loginHistory.createdAt': 'DESC' })
      .take(dto.limit)
      .skip(dto.offset)
      .getManyAndCount();
    return { result, total };
  }
}
