import { Injectable } from '@nestjs/common';
import { CreateFeedbackDto } from './dto/create-feedback.dto';
import { UpdateFeedbackDto } from './dto/update-feedback.dto';
import { Feedback } from './entities/feedback.entity';
import { InjectRepository } from '@nestjs/typeorm';
import { Like, Repository } from 'typeorm';
import { CommonPaginationDto } from 'src/common/dto/common-pagination.dto';

@Injectable()
export class FeedbackService {
  constructor(
    @InjectRepository(Feedback) private readonly repo: Repository<Feedback>,
  ) {}

  async create(dto: CreateFeedbackDto) {
    const obj = Object.create(dto);
    return this.repo.save(obj);
  }

  async findAll(dto: CommonPaginationDto, accountId: string) {
    const keyword = dto.keyword || '';
    const [result, total] = await this.repo.findAndCount({
      take: dto.limit,
      skip: dto.offset,
      where: {
        accountId: accountId,
        fName: Like('%' + keyword + '%'),
        lName: Like('%' + keyword + '%'),
        phoneNumber: Like('%' + keyword + '%'),
        message: Like('%' + keyword + '%'),
      },
      order: { createdAt: 'DESC' },
    });
    return { result, total };
  }
}
