import { Module } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { DashboardController } from './dashboard.controller';
import { DashboardService } from './dashboard.service';
import { Business } from 'src/business/entities/business.entity';
import { Licence } from 'src/licence/entities/licence.entity';
import { UserDetail } from 'src/user-details/entities/user-detail.entity';
import { MembershipCard } from 'src/membership-card/entities/membership-card.entity';
import { Account } from 'src/account/entities/account.entity';
import { UserChild } from 'src/user-child/entities/user-child.entity';
import { CardAmenity } from 'src/card-amenities/entities/card-amenity.entity';

@Module({
  imports: [
    TypeOrmModule.forFeature([
      Business,
      Licence,
      UserDetail,
      MembershipCard,
      Account,
      UserChild,
      CardAmenity
    ]),
  ],
  controllers: [DashboardController],
  providers: [DashboardService],
})
export class DashboardModule {}
