import { Account } from 'src/account/entities/account.entity';
import { MemberEntranceType } from 'src/enum';
import { UserChild } from 'src/user-child/entities/user-child.entity';
import {
  Column,
  CreateDateColumn,
  Entity,
  ManyToOne,
  PrimaryGeneratedColumn,
  UpdateDateColumn,
} from 'typeorm';

@Entity()
export class ChildLog {
  @PrimaryGeneratedColumn('uuid')
  id: string;

  @Column({ type: 'uuid', nullable: true })
  accountId: string;

  @Column({ type: 'uuid', nullable: true })
  userChildId: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  name: string;

  @Column({ type: 'date', nullable: true })
  date: string;

  @Column({ type: 'time', nullable: true })
  entryTime: string;

  @Column({ type: 'time', nullable: true })
  exitTime: string;

  @Column({ type: 'float', nullable: true })
  duration: number;

  @Column({
    type: 'enum',
    enum: MemberEntranceType,
    default: MemberEntranceType.NONE,
  })
  status: MemberEntranceType;

  @CreateDateColumn()
  createdAt: Date;

  @UpdateDateColumn()
  updatedAt: Date;

  @ManyToOne(() => Account, (account) => account.childLog, {
    cascade: true,
    onDelete: 'CASCADE',
    onUpdate: 'CASCADE',
  })
  account: Account[];

  @ManyToOne(() => UserChild, (userChild) => userChild.childLog, {
    cascade: true,
    onDelete: 'CASCADE',
    onUpdate: 'CASCADE',
  })
  userChild: UserChild[];
}
