import { Type } from 'class-transformer';
import {
  IsNotEmpty,
  IsUUID,
  IsOptional,
  IsNumber,
  IsString,
  Max,
  MaxLength,
  Min,
  MinLength,
} from 'class-validator';
import { MemberEntranceType } from 'src/enum';

export class CreateChildLogDto {
  @IsNotEmpty()
  @IsUUID()
  userChildId: string;

  @IsOptional()
  name: string;

  @IsOptional()
  date: string;

  @IsOptional()
  entryTime: string;
}

export class ChildLogPaginationDto {
  @IsNotEmpty()
  @Type(() => Number)
  @IsNumber()
  @Min(10)
  @Max(100)
  limit: number;

  @IsNotEmpty()
  @Type(() => Number)
  @IsNumber()
  @Min(0)
  offset: number;

  @IsOptional()
  @IsString()
  @MinLength(0)
  @MaxLength(100)
  keyword: string;

  @IsOptional()
  status: MemberEntranceType;

  @IsNotEmpty()
  @IsUUID()
  userChildId: string;
}
