import { Module } from '@nestjs/common';
import { ChildLogService } from './child-log.service';
import { ChildLogController } from './child-log.controller';
import { TypeOrmModule } from '@nestjs/typeorm';
import { AuthModule } from 'src/auth/auth.module';
import { ChildLog } from './entities/child-log.entity';
import { UserChild } from 'src/user-child/entities/user-child.entity';
import { UserDetail } from 'src/user-details/entities/user-detail.entity';

@Module({
  imports: [
    TypeOrmModule.forFeature([ChildLog, UserChild, UserDetail]),
    AuthModule,
  ],
  controllers: [ChildLogController],
  providers: [ChildLogService],
})
export class ChildLogModule {}
