import { IsOptional, IsString } from 'class-validator';
import { Gender } from 'src/enum';

export class UpdateBusinessDto {
  @IsOptional()
  gender: Gender;

  @IsOptional()
  personName: string;

  @IsOptional()
  personDesignation: string;

  @IsOptional()
  businessType: string; //setting

  @IsOptional()
  @IsString()
  businessName: string; //setting

  @IsOptional()
  @IsString()
  parentCompanyName: string; //setting

  @IsOptional()
  businessPhone: string;

  @IsOptional()
  businessEmail: string;

  @IsOptional()
  gstNo: string;

  @IsOptional()
  address1: string;

  @IsOptional()
  address2: string;

  @IsOptional()
  zipCode: string;

  @IsOptional()
  city: string;

  @IsOptional()
  state: string;

  @IsOptional()
  country: string;

  @IsOptional()
  signatory: string;

  @IsOptional()
  smsRoute: string;

  @IsOptional()
  smsSenderId: string;

  @IsOptional()
  smsApiKey: string;

  @IsOptional()
  accountId: string;
}
