import { Module } from '@nestjs/common';
import { BusinessService } from './business.service';
import { BusinessController } from './business.controller';
import { TypeOrmModule } from '@nestjs/typeorm';
import { AuthModule } from 'src/auth/auth.module';
import { Business } from './entities/business.entity';
import { NodeMailerModule } from 'src/node-mailer/node-mailer.module';
import { MulterModule } from '@nestjs/platform-express';
import { Account } from 'src/account/entities/account.entity';
import { Setting } from 'src/settings/entities/setting.entity';
import { Licence } from 'src/licence/entities/licence.entity';
import { Menu } from 'src/menus/entities/menu.entity';
import { MenusModule } from 'src/menus/menus.module';
import { PermissionsModule } from 'src/permissions/permissions.module';
import { UserPermissionsModule } from 'src/user-permissions/user-permissions.module';
import { UserPermission } from 'src/user-permissions/entities/user-permission.entity';
import { AdminDetail } from 'src/admin-detail/entities/admin-detail.entity';

@Module({
  imports: [
    TypeOrmModule.forFeature([
      Account,
      Business,
      Setting,
      Licence,
      Menu,
      UserPermission,
      AdminDetail
    ]),
    AuthModule,
    MenusModule,
    PermissionsModule,
    UserPermissionsModule,
    NodeMailerModule,
    MulterModule.register({ dest: './uploads/BusinessDoc' }),
  ],
  controllers: [BusinessController],
  providers: [BusinessService],
  exports: [BusinessService],
})
export class BusinessModule {}
