import {
  ConflictException,
  Injectable,
  NotFoundException,
} from '@nestjs/common';
import { CreateBusinessPaymentDto } from './dto/create-business-payment.dto';
import { UpdateBusinessPaymentDto } from './dto/update-business-payment.dto';
import { InjectRepository } from '@nestjs/typeorm';
import { Repository } from 'typeorm';
import { BusinessPayment } from './entities/business-payment.entity';
import { DefaultStatusDto } from 'src/common/dto/default-status.dto';

@Injectable()
export class BusinessPaymentService {
  constructor(
    @InjectRepository(BusinessPayment)
    private readonly repo: Repository<BusinessPayment>,
  ) {}

  async create(dto: CreateBusinessPaymentDto) {
    const result = await this.repo.findOne({
      where: { gatewayName: dto.gatewayName },
    });
    if (result) {
      throw new ConflictException('Gateway already exists!');
    }
    const obj = Object.assign(dto);
    return this.repo.save(obj);
  }

  async update(accountId: string, dto: UpdateBusinessPaymentDto) {
    const result = await this.repo.findOne({ where: { accountId } });
    if (!result) {
      throw new NotFoundException('Gateway not found!');
    }
    const obj = Object.assign(result, dto);
    return this.repo.save(obj);
  }

  async status(id: string, dto: DefaultStatusDto) {
    const result = await this.repo.findOne({ where: { id } });
    if (!result) {
      throw new NotFoundException('Gateway not found!');
    }
    const obj = Object.assign(result, { status: dto.status });
    return this.repo.save(obj);
  }
}
