import { Account } from 'src/account/entities/account.entity';
import { DefaultStatus } from 'src/enum';
import { Column, Entity, ManyToOne, PrimaryGeneratedColumn } from 'typeorm';

@Entity()
export class BusinessEmail {
  @PrimaryGeneratedColumn('uuid')
  id: string;

  @Column({ type: 'uuid', nullable: true })
  accountId: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  mailEngine: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  smtpHost: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  smtpPort: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  username: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  password: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  from: string;

  @Column({ type: 'enum', enum: DefaultStatus, default: DefaultStatus.ACTIVE })
  status: DefaultStatus;

  @Column({ type: 'boolean', default: false })
  secure: boolean;

  @ManyToOne(() => Account, (account) => account.businessEmail, {
    cascade: true,
    onDelete: 'CASCADE',
    onUpdate: 'CASCADE',
  })
  account: Account[];
}
