import {
  ConflictException,
  Injectable,
  NotFoundException,
} from '@nestjs/common';
import { CreateBusinessEmailDto } from './dto/create-business-email.dto';
import { UpdateBusinessEmailDto } from './dto/update-business-email.dto';
import { InjectRepository } from '@nestjs/typeorm';
import { Repository } from 'typeorm';
import { BusinessEmail } from './entities/business-email.entity';
import { DefaultStatusDto } from 'src/common/dto/default-status.dto';

@Injectable()
export class BusinessEmailService {
  constructor(
    @InjectRepository(BusinessEmail)
    private readonly repo: Repository<BusinessEmail>,
  ) {}

  async create(dto: CreateBusinessEmailDto) {
    const result = await this.repo.findOne({
      where: { username: dto.username },
    });
    if (result) {
      throw new ConflictException('Gateway already exists!');
    }
    const obj = Object.assign(dto);
    return this.repo.save(obj);
  }

  async update(accountId: string, dto: UpdateBusinessEmailDto) {
    const result = await this.repo.findOne({ where: { accountId } });
    if (!result) {
      throw new NotFoundException('Gateway Not Found!');
    }
    const obj = Object.assign(result, dto);
    return this.repo.save(obj);
  }

  async status(id: string, dto: DefaultStatusDto) {
    const result = await this.repo.findOne({ where: { id } });
    if (!result) {
      throw new NotFoundException('Gateway not found!');
    }
    const obj = Object.assign(result, { status: dto.status });
    return this.repo.save(obj);
  }
}
