import {
  Controller,
  Get,
  Post,
  Body,
  Patch,
  Param,
  Delete,
  UseGuards,
  Put,
} from '@nestjs/common';
import { BusinessEmailService } from './business-email.service';
import { CreateBusinessEmailDto } from './dto/create-business-email.dto';
import { UpdateBusinessEmailDto } from './dto/update-business-email.dto';
import { AuthGuard } from '@nestjs/passport';
import { Roles } from 'src/auth/decorators/roles.decorator';
import { RolesGuard } from 'src/auth/guards/roles.guard';
import { UserRole } from 'src/enum';
import { CurrentUser } from 'src/auth/decorators/current-user.decorator';
import { Account } from 'src/account/entities/account.entity';
import { DefaultStatusDto } from 'src/common/dto/default-status.dto';

@Controller('business-email')
export class BusinessEmailController {
  constructor(private readonly businessEmailService: BusinessEmailService) {}

  @Post()
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.BUSINESS)
  create(@Body() dto: CreateBusinessEmailDto, @CurrentUser() user: Account) {
    dto.accountId = user.id;
    return this.businessEmailService.create(dto);
  }

  @Patch('update')
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.BUSINESS, UserRole.ADMIN)
  update(@CurrentUser() user: Account, @Body() dto: UpdateBusinessEmailDto) {
    return this.businessEmailService.update(user.id, dto);
  }

  @Put(':id')
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.BUSINESS, UserRole.ADMIN)
  status(@Param('id') id: string, @Body() dto: DefaultStatusDto) {
    return this.businessEmailService.status(id, dto);
  }
}
