import { Injectable, NotFoundException } from '@nestjs/common';
import { CreateAdminDetailDto } from './dto/create-admin-detail.dto';
import { UpdateAdminDetailDto } from './dto/update-admin-detail.dto';
import { InjectRepository } from '@nestjs/typeorm';
import { AdminDetail } from './entities/admin-detail.entity';
import { Repository } from 'typeorm';
import { unlink } from 'fs/promises';
import { join } from 'path';

@Injectable()
export class AdminDetailService {
  constructor(
    @InjectRepository(AdminDetail)
    private readonly repo: Repository<AdminDetail>,
  ) {}

  async findOne(accountId: string) {
    return this.repo.findOne({ where: { accountId } });
  }

  async update(accountId: string, dto: UpdateAdminDetailDto) {
    const result = await this.repo.findOne({ where: { accountId } });
    if (!result) {
      throw new NotFoundException('Detail not found');
    }
    const obj = Object.assign(result, dto);
    return this.repo.save(obj);
  }

  async profile(image: string, result: AdminDetail) {
    if (result.profileImagePath) {
      const oldPath = join(__dirname, '..', '..', result.profileImagePath);
      try {
        await unlink(oldPath);
      } catch (err) {
        console.warn(`Failed to delete old image: ${oldPath}`, err.message);
      }
    }
    const obj = Object.assign(result, {
      profileImage: process.env.PV_CDN_LINK + image,
      profileImagePath: image,
    });
    return this.repo.save(obj);
  }
}
