import { Category } from 'src/category/entities/category.entity';
import { CompanySubCategory } from 'src/company-sub-category/entities/company-sub-category.entity';
import { Order } from 'src/orders/entities/order.entity';
import { OutletSubCategory } from 'src/outlet-sub-category/entities/outlet-sub-category.entity';
import {
  Column,
  CreateDateColumn,
  Entity,
  ManyToOne,
  OneToMany,
  PrimaryGeneratedColumn,
  UpdateDateColumn,
} from 'typeorm';
import { ItemType } from '../../enum';

@Entity()
export class SubCategory {
  @PrimaryGeneratedColumn('uuid')
  id: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  name: string;

  @Column({ type: 'text', nullable: true })
  image: string;

  @Column({ type: 'text', nullable: true })
  imageName: string;

  @Column({ type: 'enum', enum: ItemType, default: ItemType.VEG })
  foodType: ItemType;

  @Column({ type: 'boolean', default: false })
  status: boolean;

  @CreateDateColumn()
  createdAt: Date;

  @UpdateDateColumn()
  updatedAt: Date;

  @Column({ type: 'string', nullable: true })
  categoryId: string;

  @ManyToOne(() => Category, (category) => category.subCategory, {
    cascade: true,
    onDelete: 'CASCADE',
    onUpdate: 'CASCADE',
  })
  category: Category[];

  @OneToMany(
    () => CompanySubCategory,
    (companySubCategory) => companySubCategory.subCategory,
  )
  companySubCategory: CompanySubCategory[];

  @OneToMany(
    () => OutletSubCategory,
    (outletSubCategory) => outletSubCategory.subCategory,
  )
  outletSubCategory: OutletSubCategory[];

  @OneToMany(() => Order, (order) => order.subCategory)
  order: Order[];
}
