import {
  ConflictException,
  Injectable,
  NotAcceptableException,
  NotFoundException,
} from '@nestjs/common';
import { InjectRepository } from '@nestjs/typeorm';
import { BoolStatusDto } from 'src/common/dto/bool-status.dto';
import { Brackets, Repository } from 'typeorm';
import { RouteMasterDto, DeliveryBoyDto } from './dto/route-master.dto';
import { RouteMaster } from './entities/route-master.entity';

@Injectable()
export class RouteMasterService {
  constructor(
    @InjectRepository(RouteMaster) private readonly repo: Repository<RouteMaster>,
  ) {}

  async create(dto: RouteMasterDto) {
    const route = await this.repo.findOne({ where: { routeName: dto.routeName } });
    if (route) {
      throw new ConflictException('Route already exists!');
    }
    const obj = Object.create(dto);
    return this.repo.save(obj);
  }

  async findAll(
    limit: number,
    offset: number,
    keyword: string,
    status: boolean,
  ) {
    const [result, total] = await this.repo
      .createQueryBuilder('RouteMaster')
      .leftJoinAndSelect('RouteMaster.account', 'account')
      .leftJoinAndSelect('account.staffDetail', 'staffDetail')
      .where('RouteMaster.status = :status', { status: status })
      .andWhere(
        new Brackets((qb) => {
          qb.where('RouteMaster.routeName LIKE :routeName', {
            routeName: '%' + keyword + '%',
          });
        }),
      )
      .take(limit)
      .skip(offset)
      .getManyAndCount();

    return { result, total };
  }

  async update(id: number, dto: RouteMasterDto) {
      const result = await this.repo.findOne({ where: { id } });
      if (!result) {
        throw new NotFoundException('Route Master not found!');
      }
      const obj = Object.assign(result, dto);
      return this.repo.save(obj);
  }

  async updateDeliveryBoy(id: number, dto: DeliveryBoyDto) {
    const result = await this.repo.findOne({ where: { id } });
      if (!result) {
        throw new NotFoundException('Route Master not found!');
      }
      const obj = Object.assign(result, dto);
      return this.repo.save(obj);
  }

  async status(id: number, dto: BoolStatusDto) {
    const result = await this.repo.findOne({ where: { id } });
    if (!result) {
      throw new NotFoundException('Route Master not found!');
    }
    const obj = Object.assign(result, dto);
    return this.repo.save(obj);
  }

  async remove(id: number) {
    const result = await this.repo.findOne({ where: { id } });
    if (!result) {
      throw new NotFoundException('Not found!');
    }
    return this.repo.remove(result);
  }
}
