import {
  Injectable,
  NotFoundException,
} from '@nestjs/common';
import { InjectRepository } from '@nestjs/typeorm';
import { Repository } from 'typeorm';
import {
  PaginationAllDto
} from './dto/route-assgin-log.dto';
import { RouteAssginLog } from './entities/route-assgin-log.entity';

@Injectable()
export class RouteAssginLogService {
  constructor(
    @InjectRepository(RouteAssginLog) 
    private readonly repo: Repository<RouteAssginLog>,
  ) {}

  async findAll(dto: PaginationAllDto) {
    const fromDate = new Date(dto.fromDate);
    fromDate.setHours(0, 0, 0, 0);

    const toDate = new Date(dto.toDate);
    toDate.setHours(23, 59, 59, 59);
    
    const query = this.repo
      .createQueryBuilder('RouteAssginLog')
      .leftJoinAndSelect('RouteAssginLog.outletDetail', 'outletDetail')
      .select([
        'outletDetail.id',
        'outletDetail.storeName',

        'RouteAssginLog.id',
        'RouteAssginLog.fromRoute',
        'RouteAssginLog.toRoute',
        'RouteAssginLog.createdAt',
      ]);
      query.where(
        'RouteAssginLog.createdAt >= :fromDate and RouteAssginLog.createdAt <= :toDate',
        { fromDate: fromDate, toDate: toDate },
      );
    const [result, total] = await query
      .orderBy({ 'RouteAssginLog.createdAt': 'DESC' })
      .take(dto.limit)
      .skip(dto.offset)
      .getManyAndCount();
    return { result, total };
  }

  async findOne(id: any) {
    const result = await this.repo.findOne({ where: { id } });
    if (!result) {
      throw new NotFoundException('Log not found!');
    }
    return result;
  }
}
