import { OutletBranch } from 'src/outlet-branch/entities/outlet-branch.entity';
import { SubCategory } from 'src/sub-category/entities/sub-category.entity';
import {
  Column,
  CreateDateColumn,
  Entity,
  ManyToOne,
  PrimaryGeneratedColumn,
  UpdateDateColumn,
} from 'typeorm';

@Entity()
export class OutletSubCategory {
  @PrimaryGeneratedColumn('uuid')
  id: string;

  @Column({ type: 'uuid', nullable: true })
  outletBranchId: string;

  @Column({ type: 'uuid', nullable: true })
  subCategoryId: string;

  @Column({ type: 'boolean', default: true })
  status: boolean;

  @CreateDateColumn()
  createdAt: Date;

  @UpdateDateColumn()
  updatedAt: Date;

  @ManyToOne(
    () => OutletBranch,
    (outletBranch) => outletBranch.outletSubCategory,
    {
      cascade: true,
      onDelete: 'CASCADE',
      onUpdate: 'CASCADE',
    },
  )
  outletBranch: OutletBranch[];

  @ManyToOne(
    () => SubCategory,
    (subCategory) => subCategory.outletSubCategory,
    {
      cascade: true,
      onDelete: 'CASCADE',
      onUpdate: 'CASCADE',
    },
  )
  subCategory: SubCategory[];
}
