import {
  Body,
  Controller,
  Delete,
  Get,
  Param,
  Post,
  Put,
  UseGuards,
} from '@nestjs/common';
import { AuthGuard } from '@nestjs/passport';
import { ApiOperation } from '@nestjs/swagger';
import { Roles } from 'src/auth/decorators/roles.decorator';
import { RolesGuard } from 'src/auth/guards/roles.guard';
import { CompanyCategoryDto } from 'src/company-category/dto/company-category.dto';
import { UserRole } from 'src/enum';
import { OutletCategoryService } from './outlet-category.service';
import { OutletCategoryDto, BoolStatusDto } from './dto/outlet-category.dto';

@Controller('outlet-category')
export class OutletCategoryController {
  constructor(private readonly outletCategoryService: OutletCategoryService) {}

  @Post(':id')
  @ApiOperation({ summary: 'For Vendor' })
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.ADMIN, UserRole.SUPER_ADMIN, UserRole.STAFF)
  create(@Param('id') id: string, @Body() dto: OutletCategoryDto) {
    dto.outletBranchId = id;
    return this.outletCategoryService.create(dto);
  }

  @Get(':id')
  @ApiOperation({ summary: 'For Vendor' })
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.ADMIN, UserRole.SUPER_ADMIN, UserRole.STAFF)
  findAll(@Param('id') id: string) {
    return this.outletCategoryService.findAll(id);
  }

  @Put(':id')
  @ApiOperation({ summary: 'For Admin' })
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.ADMIN, UserRole.SUPER_ADMIN, UserRole.STAFF)
  status(@Param('id') id: string, @Body() dto: BoolStatusDto) {
    return this.outletCategoryService.status(id, dto);
  }

  @Delete(':id')
  @ApiOperation({ summary: 'For Vendor' })
  @UseGuards(AuthGuard('jwt'), RolesGuard)
  @Roles(UserRole.ADMIN, UserRole.SUPER_ADMIN, UserRole.STAFF)
  remove(@Param('id') id: string) {
    return this.outletCategoryService.remove(id);
  }
}
