import { ApiProperty } from '@nestjs/swagger';
import { Type } from 'class-transformer';
import {
  IsEmail,
  IsEnum,
  IsNotEmpty,
  IsNumber,
  IsOptional,
  IsString,
  IsUUID,
  Max,
  MaxLength,
  Min,
  MinLength,
} from 'class-validator';
import { CompanyStatus } from 'src/enum';

export class OutletBranchDto {
  @IsNotEmpty()
  @ApiProperty()
  @IsString()
  @MinLength(1)
  @MaxLength(50)
  branchName: string;

  @IsNotEmpty()
  @ApiProperty()
  @IsString()
  @MinLength(1)
  @MaxLength(50)
  contactPersonName: string;

  @IsNotEmpty()
  @ApiProperty()
  @IsString()
  @MinLength(10)
  @MaxLength(20)
  phone: string;

  @IsNotEmpty()
  @ApiProperty()
  @IsEmail()
  @MinLength(5)
  @MaxLength(50)
  email: string;

  @IsNotEmpty()
  @ApiProperty()
  @IsUUID()
  companyDetailId: string;

  @IsNotEmpty()
  @ApiProperty()
  @IsNumber()
  @Min(0)
  stateId: number;

  @IsNotEmpty()
  @ApiProperty()
  @IsNumber()
  @Min(0)
  cityId: number;
}


export class StatusDto {
  @IsNotEmpty()
  @ApiProperty()
  @IsEnum(CompanyStatus)
  status: CompanyStatus;
}

export class PaginationSDto {
  @ApiProperty()
  @IsNotEmpty()
  @Type(() => Number)
  @IsNumber()
  @Min(10)
  @Max(50)
  limit: number;

  @ApiProperty()
  @IsNotEmpty()
  @Type(() => Number)
  @IsNumber()
  @Min(0)
  offset: number;

  @ApiProperty()
  @IsOptional()
  keyword: string;

  @ApiProperty()
  @IsNotEmpty()
  @IsEnum(CompanyStatus)
  status: CompanyStatus;
}

export class PaginationDto {
  @ApiProperty()
  @IsNotEmpty()
  @Type(() => Number)
  @IsNumber()
  @Min(10)
  @Max(50)
  limit: number;

  @ApiProperty()
  @IsNotEmpty()
  @Type(() => Number)
  @IsNumber()
  @Min(0)
  offset: number;

  @ApiProperty()
  @IsOptional()
  keyword: string;
}
