import { Exclude } from 'class-transformer';
import { Account } from 'src/account/entities/account.entity';
import { ContactUsStatus } from 'src/enum';
import {
  BeforeInsert,
  Column,
  CreateDateColumn,
  Entity,
  ManyToOne,
  PrimaryGeneratedColumn,
  UpdateDateColumn,
} from 'typeorm';

@Entity()
export class ContactUs {
  @Exclude()
  @PrimaryGeneratedColumn('uuid')
  id: string;

  @Column({ type: 'varchar', length: 50, unique: true })
  contactUsId: string;

  @Column({ type: 'varchar', length: 50, unique: true })
  email: string;

  @Column({ type: 'varchar', length: 20, unique: true })
  phone: string;

  @Column({ type: 'varchar', length: 200, unique: true })
  subject: string;

  @Column({ type: 'text', nullable: true })
  body: string;

  @Column({ type: 'text', nullable: true })
  answer: string;

  @Exclude()
  @Column({
    type: 'enum',
    enum: ContactUsStatus,
    default: ContactUsStatus.PENDING,
  })
  status: ContactUsStatus;

  @Exclude()
  @Column({ type: 'varchar', length: 50, nullable: true })
  ip: string;

  @Exclude()
  @Column({ type: 'varchar', length: 50, nullable: true })
  latitude: string;

  @Exclude()
  @Column({ type: 'varchar', length: 50, nullable: true })
  longitude: string;

  @CreateDateColumn()
  createdAt: Date;

  @UpdateDateColumn()
  updatedAt: Date;

  @Column({ type: 'uuid', nullable: true })
  accountId: string;

  @ManyToOne(() => Account, (account) => account.feedback, {
    cascade: true,
    onDelete: 'CASCADE',
    onUpdate: 'CASCADE',
  })
  account: Account[];

  @BeforeInsert()
  generateRandomId() {
    this.contactUsId = Date.now().toString();
  }
}
