import { CompanyCategory } from 'src/company-category/entities/company-category.entity';
import { OutletCategory } from 'src/outlet-category/entities/outlet-category.entity';
import { SubCategory } from 'src/sub-category/entities/sub-category.entity';
import {
  Column,
  CreateDateColumn,
  Entity,
  OneToMany,
  PrimaryGeneratedColumn,
  UpdateDateColumn,
} from 'typeorm';

@Entity()
export class Category {
  @PrimaryGeneratedColumn('uuid')
  id: string;

  @Column({ type: 'varchar', length: 100, nullable: true })
  name: string;

  @Column({ type: 'boolean', default: false })
  status: boolean;

  @CreateDateColumn()
  createdAt: Date;

  @UpdateDateColumn()
  updatedAt: Date;

  @OneToMany(() => SubCategory, (subCategory) => subCategory.category)
  subCategory: SubCategory[];

  @OneToMany(
    () => CompanyCategory,
    (companyCategory) => companyCategory.category,
  )
  companyCategory: CompanyCategory[];

  @OneToMany(() => OutletCategory, (outletCategory) => outletCategory.category)
  outletCategory: OutletCategory[];
}
