import { ApiProperty } from '@nestjs/swagger';
import { IsNotEmpty } from 'class-validator';

export class MobLoginDto {
  @ApiProperty()
  @IsNotEmpty()
  loginId: string;

  @ApiProperty()
  @IsNotEmpty()
  password: string;

  @ApiProperty()
  @IsNotEmpty()
  deviceId: string;

  @ApiProperty()
  @IsNotEmpty()
  fcm: string;

  @ApiProperty()
  @IsNotEmpty()
  latitude: string;

  @ApiProperty()
  @IsNotEmpty()
  longitude: string;

  @ApiProperty()
  @IsNotEmpty()
  type: string;
}

export class WebLoginDto {
  @ApiProperty()
  @IsNotEmpty()
  loginId: string;
}

export class SigninDto {
  @ApiProperty()
  @IsNotEmpty()
  loginId: string;

  @ApiProperty()
  @IsNotEmpty()
  password: string;
}

export class PassDto {
  @ApiProperty()
  @IsNotEmpty()
  password: string;
}
