import { City } from 'src/city/entities/city.entity';
import { OutletDetail } from 'src/outlet-details/entities/outlet-detail.entity';
import {
  Column,
  CreateDateColumn,
  Entity,
  ManyToOne,
  OneToMany,
  PrimaryGeneratedColumn,
  UpdateDateColumn,
} from 'typeorm';

@Entity()
export class Area {
  @PrimaryGeneratedColumn('increment')
  id: number;

  @Column({ type: 'varchar', length: 50 })
  name: string;

  @Column({ type: 'boolean', default: false })
  status: boolean;

  @CreateDateColumn()
  createdAt: Date;

  @UpdateDateColumn()
  updatedAt: Date;

  @Column({ type: 'int' })
  cityId: number;

  @ManyToOne(() => City, (city) => city.area, {
    cascade: true,
    onUpdate: 'CASCADE',
    onDelete: 'CASCADE',
  })
  city: City[];

  @OneToMany(() => OutletDetail, (outletDetail) => outletDetail.area)
  outletDetail: OutletDetail;
}
