"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TicketsService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const enum_1 = require("../enum");
const typeorm_2 = require("typeorm");
const ticket_entity_1 = require("./entities/ticket.entity");
let TicketsService = class TicketsService {
    constructor(repo) {
        this.repo = repo;
    }
    async create(dto) {
        const result = await this.repo.count({
            where: {
                accountId: dto.accountId,
                status: enum_1.TicketStatus.PENDING,
                createdAt: new Date(),
            },
        });
        if (result > 9) {
            throw new common_1.ConflictException('Only 10 ticket allowed at single day!');
        }
        const obj = Object.create(dto);
        return this.repo.save(obj);
    }
    async findAll(dto) {
        const keyword = dto.keyword || '';
        const [result, total] = await this.repo
            .createQueryBuilder('ticket')
            .where('ticket.status = :status', { status: dto.status })
            .andWhere(new typeorm_2.Brackets((qb) => {
            qb.where('ticket.question LIKE :question OR ticket.answer LIKE :answer', {
                question: '%' + keyword + '%',
                answer: '%' + keyword + '%',
            });
        }))
            .orderBy({ 'ticket.createdAt': 'DESC' })
            .skip(dto.offset)
            .take(dto.limit)
            .getManyAndCount();
        return { result, total };
    }
    async findReportAll(dto) {
        const fromDate = new Date(dto.fromDate);
        fromDate.setHours(0, 0, 0, 0);
        const toDate = new Date(dto.toDate);
        toDate.setHours(23, 59, 59, 59);
        const query = this.repo
            .createQueryBuilder('ticket')
            .leftJoinAndSelect('ticket.account', 'account')
            .leftJoinAndSelect('account.outletDetail', 'outletDetail')
            .select([
            'account.id',
            'account.loginId',
            'outletDetail.id',
            'outletDetail.storeName',
            'ticket.id',
            'ticket.image',
            'ticket.question',
            'ticket.answer',
            'ticket.status',
            'ticket.createdAt'
        ]);
        query.where('ticket.createdAt >= :fromDate and ticket.createdAt <= :toDate', { fromDate: fromDate, toDate: toDate });
        const [result, total] = await query
            .orderBy({ 'ticket.createdAt': 'DESC' })
            .take(dto.limit)
            .skip(dto.offset)
            .getManyAndCount();
        return { result, total };
    }
    async find(id, dto) {
        const keyword = dto.keyword || '';
        const [result, total] = await this.repo
            .createQueryBuilder('ticket')
            .where('ticket.status = :status AND ticket.accountId = :accountId', {
            status: dto.status,
            accountId: id,
        })
            .andWhere(new typeorm_2.Brackets((qb) => {
            qb.where('ticket.question LIKE :question OR ticket.answer LIKE :answer', {
                question: '%' + keyword + '%',
                answer: '%' + keyword + '%',
            });
        }))
            .orderBy({ 'ticket.createdAt': 'DESC' })
            .skip(dto.offset)
            .take(dto.limit)
            .getManyAndCount();
        return { result, total };
    }
    async findOne(id) {
        const result = await this.repo.count({ where: { id } });
        if (!result) {
            throw new common_1.NotFoundException('Ticket not found!');
        }
        return result;
    }
    async update(id, dto) {
        const result = await this.repo.findOne({ where: { id } });
        if (!result) {
            throw new common_1.NotFoundException('Ticket not found!');
        }
        const obj = Object.assign(result, dto);
        return this.repo.save(obj);
    }
};
TicketsService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(ticket_entity_1.Ticket)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], TicketsService);
exports.TicketsService = TicketsService;
//# sourceMappingURL=tickets.service.js.map