import { Repository } from 'typeorm';
import { PaginationAllDto, TicketAnswerDto, TicketDto, PaginationReportDto } from './dto/ticket.dto';
import { Ticket } from './entities/ticket.entity';
export declare class TicketsService {
    private readonly repo;
    constructor(repo: Repository<Ticket>);
    create(dto: TicketDto): Promise<any>;
    findAll(dto: PaginationAllDto): Promise<{
        result: Ticket[];
        total: number;
    }>;
    findReportAll(dto: PaginationReportDto): Promise<{
        result: Ticket[];
        total: number;
    }>;
    find(id: string, dto: PaginationAllDto): Promise<{
        result: Ticket[];
        total: number;
    }>;
    findOne(id: string): Promise<number>;
    update(id: string, dto: TicketAnswerDto): Promise<Ticket & TicketAnswerDto>;
}
