"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SubCategoryService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const enum_1 = require("../enum");
const typeorm_2 = require("typeorm");
const sub_category_entity_1 = require("./entities/sub-category.entity");
let SubCategoryService = class SubCategoryService {
    constructor(repo) {
        this.repo = repo;
    }
    async create(dto) {
        const category = await this.repo.findOne({
            where: { name: dto.name, categoryId: dto.categoryId },
        });
        if (category) {
            throw new common_1.ConflictException('Category already exists!');
        }
        const obj = Object.create(dto);
        return this.repo.save(obj);
    }
    async findAll(limit, offset, keyword, status, categoryId) {
        const [result, total] = await this.repo
            .createQueryBuilder('subCategory')
            .where('subCategory.status = :status AND subCategory.categoryId = :categoryId', { status: status, categoryId: categoryId })
            .andWhere(new typeorm_2.Brackets((qb) => {
            qb.where('subCategory.name LIKE :pname', {
                pname: '%' + keyword + '%',
            });
        }))
            .orderBy(`CASE WHEN subCategory.name LIKE '${keyword}%' THEN 0 ELSE 1 END, subCategory.name`, 'ASC')
            .take(limit)
            .skip(offset)
            .getManyAndCount();
        return { result, total };
    }
    async findSub(limit, offset, keyword) {
        const [result, total] = await this.repo
            .createQueryBuilder('subCategory')
            .where('subCategory.status = :status', { status: true })
            .andWhere(new typeorm_2.Brackets((qb) => {
            qb.where('subCategory.name LIKE :pname', {
                pname: '%' + keyword + '%',
            });
        }))
            .orderBy(`CASE WHEN subCategory.name LIKE '${keyword}%' THEN 0 ELSE 1 END, subCategory.name`, 'ASC')
            .take(limit)
            .skip(offset)
            .getManyAndCount();
        return { result, total };
    }
    async find(limit, offset, keyword, categoryId) {
        const [result, total] = await this.repo
            .createQueryBuilder('subCategory')
            .where('subCategory.status = :status AND subCategory.categoryId = :categoryId', { status: true, categoryId: categoryId })
            .andWhere(new typeorm_2.Brackets((qb) => {
            qb.where('subCategory.name LIKE :pname', {
                pname: '%' + keyword + '%',
            });
        }))
            .orderBy(`CASE WHEN subCategory.name LIKE '${keyword}%' THEN 0 ELSE 1 END, subCategory.name`, 'ASC')
            .take(limit)
            .skip(offset)
            .getManyAndCount();
        return { result, total };
    }
    async findsubcate(categoryId) {
        const result = await this.repo
            .createQueryBuilder('subCategory')
            .where('subCategory.status = :status AND subCategory.categoryId = :categoryId', { status: true, categoryId: categoryId })
            .getMany();
        return { result };
    }
    async findByMultiCat(limit, offset, keyword, categories) {
        const [result, total] = await this.repo
            .createQueryBuilder('subCategory')
            .where('subCategory.status = :status AND subCategory.categoryId IN :categoryId', { status: true, categoryId: categories })
            .andWhere(new typeorm_2.Brackets((qb) => {
            qb.where('subCategory.name LIKE :pname', {
                pname: '%' + keyword + '%',
            });
        }))
            .orderBy(`CASE WHEN subCategory.name LIKE '${keyword}%' THEN 0 ELSE 1 END, subCategory.name`, 'ASC')
            .take(limit)
            .skip(offset)
            .getManyAndCount();
        return { result, total };
    }
    async products(limit, offset, keyword, status, cartId, outletDetailId, outletBranchId) {
        const query = this.repo
            .createQueryBuilder('subCategory')
            .leftJoinAndSelect('subCategory.outletSubCategory', 'outletSubCategory');
        if (cartId && cartId.length > 3 && cartId != 'null') {
            query.leftJoinAndSelect('subCategory.order', 'order', 'order.outletDetailId = :outletDetailId AND order.status IN (:...ostatus) AND order.cartId = :cartId', {
                outletDetailId: outletDetailId,
                ostatus: [enum_1.OrderStatus.CART, enum_1.OrderStatus.ORDERED],
                cartId: cartId,
            });
        }
        else {
            query.leftJoinAndSelect('subCategory.order', 'order', 'order.outletDetailId = :outletDetailId AND order.status IN (:...ostatus) AND order.cartId IS NULL', {
                outletDetailId: outletDetailId,
                ostatus: [enum_1.OrderStatus.CART, enum_1.OrderStatus.ORDERED],
            });
        }
        const data = await query
            .leftJoinAndSelect('subCategory.category', 'category')
            .select([
            'subCategory.id',
            'subCategory.name',
            'subCategory.image',
            'subCategory.foodType',
            'category.id',
            'category.name',
            'order.id',
            'order.quantity',
            'order.status',
            'order.createdAt',
        ])
            .where('subCategory.status = :status AND outletSubCategory.outletBranchId = :outletBranchId', { status: true, outletBranchId: outletBranchId })
            .andWhere(new typeorm_2.Brackets((qb) => {
            qb.where('subCategory.name LIKE :pname', {
                pname: '%' + keyword + '%',
            });
        }))
            .orderBy({ 'subCategory.name': 'ASC' })
            .take(limit)
            .skip(offset)
            .getRawMany();
        const queryOrder = this.repo
            .createQueryBuilder('subCategory')
            .leftJoinAndSelect('subCategory.outletSubCategory', 'outletSubCategory');
        if (cartId && cartId.length > 3 && cartId != 'null') {
            queryOrder.leftJoinAndSelect('subCategory.order', 'order', 'order.outletDetailId = :outletDetailId AND order.status IN (:...ostatus) AND order.cartId = :cartId', {
                outletDetailId: outletDetailId,
                ostatus: [enum_1.OrderStatus.CART, enum_1.OrderStatus.ORDERED],
                cartId: cartId,
            });
        }
        else {
            queryOrder.leftJoinAndSelect('subCategory.order', 'order', 'order.outletDetailId = :outletDetailId AND order.status IN (:...ostatus) AND order.cartId IS NULL', {
                outletDetailId: outletDetailId,
                ostatus: [enum_1.OrderStatus.CART, enum_1.OrderStatus.ORDERED],
            });
        }
        const order = await queryOrder
            .select([
            'subCategory.id',
            'order.id',
            'order.cartId',
            'order.status',
            'order.createdAt',
        ])
            .where('subCategory.status = :status AND  outletSubCategory.outletBranchId = :outletBranchId', { status: true, outletBranchId: outletBranchId })
            .orderBy({ 'subCategory.name': 'ASC' })
            .getOne();
        return { data, order };
    }
    async findOne(id) {
        const category = await this.repo.findOne({ where: { id } });
        if (!category) {
            throw new common_1.NotFoundException('Category not found!');
        }
        return category;
    }
    async update(id, dto) {
        try {
            const category = await this.repo.findOne({ where: { id } });
            if (!category) {
                throw new common_1.NotFoundException('Category not found!');
            }
            const obj = Object.assign(category, {
                name: dto.name,
                foodType: dto.foodType,
            });
            return this.repo.save(obj);
        }
        catch (error) {
            throw new common_1.NotAcceptableException('Either catgeory exists or invalid name!');
        }
    }
    async image(id, image) {
        const result = await this.repo.findOne({ where: { id } });
        if (!result) {
            throw new common_1.NotFoundException('Order not found!');
        }
        const obj = Object.assign(result, {
            image: process.env.ST_CDN_LINK + image,
            imageName: image,
        });
        return this.repo.save(obj);
    }
    async status(id, dto) {
        const menu = await this.repo.findOne({ where: { id } });
        if (!menu) {
            throw new common_1.NotFoundException('Category not found!');
        }
        const obj = Object.assign(menu, dto);
        return this.repo.save(obj);
    }
};
SubCategoryService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(sub_category_entity_1.SubCategory)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], SubCategoryService);
exports.SubCategoryService = SubCategoryService;
//# sourceMappingURL=sub-category.service.js.map