"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SubCategory = void 0;
const category_entity_1 = require("../../category/entities/category.entity");
const company_sub_category_entity_1 = require("../../company-sub-category/entities/company-sub-category.entity");
const order_entity_1 = require("../../orders/entities/order.entity");
const outlet_sub_category_entity_1 = require("../../outlet-sub-category/entities/outlet-sub-category.entity");
const typeorm_1 = require("typeorm");
const enum_1 = require("../../enum");
let SubCategory = class SubCategory {
};
__decorate([
    (0, typeorm_1.PrimaryGeneratedColumn)('uuid'),
    __metadata("design:type", String)
], SubCategory.prototype, "id", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'varchar', length: 100, nullable: true }),
    __metadata("design:type", String)
], SubCategory.prototype, "name", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'text', nullable: true }),
    __metadata("design:type", String)
], SubCategory.prototype, "image", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'text', nullable: true }),
    __metadata("design:type", String)
], SubCategory.prototype, "imageName", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'enum', enum: enum_1.ItemType, default: enum_1.ItemType.VEG }),
    __metadata("design:type", String)
], SubCategory.prototype, "foodType", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'boolean', default: false }),
    __metadata("design:type", Boolean)
], SubCategory.prototype, "status", void 0);
__decorate([
    (0, typeorm_1.CreateDateColumn)(),
    __metadata("design:type", Date)
], SubCategory.prototype, "createdAt", void 0);
__decorate([
    (0, typeorm_1.UpdateDateColumn)(),
    __metadata("design:type", Date)
], SubCategory.prototype, "updatedAt", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'string', nullable: true }),
    __metadata("design:type", String)
], SubCategory.prototype, "categoryId", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => category_entity_1.Category, (category) => category.subCategory, {
        cascade: true,
        onDelete: 'CASCADE',
        onUpdate: 'CASCADE',
    }),
    __metadata("design:type", Array)
], SubCategory.prototype, "category", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => company_sub_category_entity_1.CompanySubCategory, (companySubCategory) => companySubCategory.subCategory),
    __metadata("design:type", Array)
], SubCategory.prototype, "companySubCategory", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => outlet_sub_category_entity_1.OutletSubCategory, (outletSubCategory) => outletSubCategory.subCategory),
    __metadata("design:type", Array)
], SubCategory.prototype, "outletSubCategory", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => order_entity_1.Order, (order) => order.subCategory),
    __metadata("design:type", Array)
], SubCategory.prototype, "order", void 0);
SubCategory = __decorate([
    (0, typeorm_1.Entity)()
], SubCategory);
exports.SubCategory = SubCategory;
//# sourceMappingURL=sub-category.entity.js.map