"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StaffDetailsService = void 0;
const cache_manager_1 = require("@nestjs/cache-manager");
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const menu_entity_1 = require("../menus/entities/menu.entity");
const typeorm_2 = require("typeorm");
const staff_detail_entity_1 = require("./entities/staff-detail.entity");
let StaffDetailsService = class StaffDetailsService {
    constructor(repo, menuRepo, cacheManager) {
        this.repo = repo;
        this.menuRepo = menuRepo;
        this.cacheManager = cacheManager;
    }
    async create(dto) {
        const user = await this.repo.findOne({
            where: { accountId: dto.accountId },
        });
        if (user) {
            try {
                if (user) {
                    const obj = Object.assign(user, dto);
                    return this.repo.save(obj);
                }
                else {
                    const obj = Object.create(dto);
                    return this.repo.save(obj);
                }
            }
            catch (error) {
                throw new common_1.NotAcceptableException('Either duplicate email or invalid details!');
            }
        }
    }
    async update(accountId, dto) {
        const user = await this.repo.findOne({
            where: { accountId: accountId },
        });
        if (!user) {
            throw new common_1.NotFoundException('Account not found!');
        }
        try {
            this.delStaffDetail(user.accountId);
            const obj = Object.assign(user, dto);
            return this.repo.save(obj);
        }
        catch (error) {
            throw new common_1.NotAcceptableException('Either duplicate email/pan number/aadhar number or invalid details!');
        }
    }
    async findOne(accountId) {
        const user = await this.repo.findOne({ where: { accountId } });
        if (!user) {
            throw new common_1.NotFoundException('User not found!');
        }
        return user;
    }
    profile(id) {
        return this.getStaffDetail(id);
    }
    async image(accountId, image) {
        const user = await this.repo.findOne({
            where: [{ accountId }, { id: accountId }],
        });
        if (!user) {
            throw new common_1.NotFoundException('User not found!');
        }
        const obj = Object.assign(user, {
            profile: process.env.CDN_LINK + image,
            profileName: image,
        });
        this.delStaffDetail(accountId);
        return this.repo.save(obj);
    }
    async pan(accountId, image) {
        const user = await this.repo.findOne({
            where: [{ accountId }, { id: accountId }],
        });
        if (!user) {
            throw new common_1.NotFoundException('User not found!');
        }
        const obj = Object.assign(user, {
            pan: process.env.CDN_LINK + image,
            panName: image,
        });
        this.delStaffDetail(accountId);
        return this.repo.save(obj);
    }
    async aadhar(accountId, image) {
        const user = await this.repo.findOne({ where: [{ accountId }, { id: accountId }] });
        if (!user) {
            throw new common_1.NotFoundException('User not found!');
        }
        const obj = Object.assign(user, {
            aadhar: process.env.CDN_LINK + image,
            aadharName: image,
        });
        this.delStaffDetail(accountId);
        return this.repo.save(obj);
    }
    delStaffDetail(id) {
        this.cacheManager.del('staffDetail' + id);
    }
    async getStaffDetail(id) {
        const user = await this.repo
            .createQueryBuilder('staffDetail')
            .leftJoinAndSelect('staffDetail.account', 'account')
            .where('staffDetail.accountId = :accountId', { accountId: id })
            .getOne();
        if (!user) {
            throw new common_1.NotFoundException('Account details not found!');
        }
        const perms = await this.menuRepo
            .createQueryBuilder('menu')
            .leftJoinAndSelect('menu.userPermission', 'userPermission')
            .leftJoinAndSelect('userPermission.permission', 'permission')
            .where('userPermission.accountId = :accountId', { accountId: id })
            .orderBy({ 'menu.title': 'ASC', 'permission.id': 'ASC' })
            .getMany();
        return { user, perms };
    }
};
StaffDetailsService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(staff_detail_entity_1.StaffDetail)),
    __param(1, (0, typeorm_1.InjectRepository)(menu_entity_1.Menu)),
    __param(2, (0, common_1.Inject)(cache_manager_1.CACHE_MANAGER)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository, Object])
], StaffDetailsService);
exports.StaffDetailsService = StaffDetailsService;
//# sourceMappingURL=staff-details.service.js.map