/// <reference types="multer" />
import { Account } from 'src/account/entities/account.entity';
import { UpdateStaffDetailDto } from './dto/staff-detail.dto';
import { StaffDetailsService } from './staff-details.service';
export declare class StaffDetailsController {
    private readonly staffDetailsService;
    constructor(staffDetailsService: StaffDetailsService);
    getProfile(user: Account): Promise<{
        user: import("./entities/staff-detail.entity").StaffDetail;
        perms: import("../menus/entities/menu.entity").Menu[];
    }>;
    findOne(id: string): Promise<{
        user: import("./entities/staff-detail.entity").StaffDetail;
        perms: import("../menus/entities/menu.entity").Menu[];
    }>;
    updateProfileById(id: string, user: Account, dto: UpdateStaffDetailDto): Promise<import("./entities/staff-detail.entity").StaffDetail & UpdateStaffDetailDto>;
    updateProfile(user: Account, dto: UpdateStaffDetailDto): Promise<import("./entities/staff-detail.entity").StaffDetail & UpdateStaffDetailDto>;
    aadhar(id: string, file: Express.Multer.File): Promise<import("./entities/staff-detail.entity").StaffDetail & {
        aadhar: string;
        aadharName: string;
    }>;
    pan(id: string, file: Express.Multer.File): Promise<import("./entities/staff-detail.entity").StaffDetail & {
        pan: string;
        panName: string;
    }>;
    profile(id: string, file: Express.Multer.File): Promise<import("./entities/staff-detail.entity").StaffDetail & {
        profile: string;
        profileName: string;
    }>;
}
