import { Cache } from 'cache-manager';
import { Repository } from 'typeorm';
import { PaginationDto } from './dto/pagination.dto';
import { SettingDto } from './dto/setting.dto';
import { StatusSettingDto } from './dto/status-setting.dto';
import { Setting } from './entities/setting.entity';
export declare class SettingsService {
    private readonly repo;
    private cacheManager;
    constructor(repo: Repository<Setting>, cacheManager: Cache);
    findAll(dto: PaginationDto): Promise<{
        result: Setting[];
        total: number;
    }>;
    findOne(id: string): Promise<Setting>;
    findSetting(domain: string): Promise<Setting>;
    update(id: string, dto: SettingDto): Promise<Setting & SettingDto>;
    status(id: string, dto: StatusSettingDto): Promise<Setting & StatusSettingDto>;
    private deleteSetting;
    getAppSetting(id: string): Promise<{
        result: Setting;
    }>;
    private getSetting;
}
