import { NotifyService } from 'src/notify/notify.service';
import { PaginationDto } from './dto/pagination.dto';
import { SettingDto } from './dto/setting.dto';
import { StatusSettingDto } from './dto/status-setting.dto';
import { SettingsService } from './settings.service';
export declare class SettingsController {
    private readonly settingsService;
    private readonly notifyService;
    version: Date;
    constructor(settingsService: SettingsService, notifyService: NotifyService);
    findSettings(origin: string): Promise<import("./entities/setting.entity").Setting>;
    findAll(query: PaginationDto): Promise<{
        result: import("./entities/setting.entity").Setting[];
        total: number;
    }>;
    findOne(id: string): Promise<import("./entities/setting.entity").Setting>;
    findOneSetting(id: string): Promise<{
        result: import("./entities/setting.entity").Setting;
    }>;
    update(id: string, dto: SettingDto): Promise<import("./entities/setting.entity").Setting & SettingDto>;
    status(id: string, dto: StatusSettingDto): Promise<import("./entities/setting.entity").Setting & StatusSettingDto>;
}
