"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OutletDetailsService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const account_service_1 = require("../account/account.service");
const notify_service_1 = require("../notify/notify.service");
const typeorm_2 = require("typeorm");
const outlet_detail_entity_1 = require("./entities/outlet-detail.entity");
const route_assgin_log_entity_1 = require("../route-assgin-log/entities/route-assgin-log.entity");
let OutletDetailsService = class OutletDetailsService {
    constructor(repo, ralRepo, accountService, notifyService) {
        this.repo = repo;
        this.ralRepo = ralRepo;
        this.accountService = accountService;
        this.notifyService = notifyService;
    }
    async create(dto, createdBy) {
        const account = await this.accountService.outletDetail(dto.loginId, dto.password, createdBy);
        const result = await this.repo.findOne({
            where: {
                storeName: dto.storeName,
                contactPerson: dto.contactPerson,
                address: dto.address,
                latitude: dto.latitude,
                longitude: dto.longitude,
                outletBranchId: dto.outletBranchId,
            },
        });
        if (result) {
            throw new common_1.ConflictException('Outlet already exists!');
        }
        dto.accountId = account.id;
        dto.outletId = await Date.now().toString();
        const obj = Object.create(dto);
        return this.repo.save(obj);
    }
    async findAll(dto) {
        const keyword = dto.keyword || '';
        const [result, total] = await this.repo
            .createQueryBuilder('outletDetail')
            .leftJoinAndSelect('outletDetail.outletBranch', 'outletBranch')
            .leftJoinAndSelect('outletDetail.routeMaster', 'routeMaster')
            .leftJoinAndSelect('outletDetail.account', 'outletAccount')
            .leftJoinAndSelect('routeMaster.account', 'account')
            .leftJoinAndSelect('account.staffDetail', 'staffDetail')
            .leftJoinAndSelect('outletDetail.area', 'area')
            .leftJoinAndSelect('outletDetail.city', 'city')
            .leftJoinAndSelect('outletDetail.state', 'state')
            .where('outletDetail.status = :status', {
            status: dto.status,
        })
            .andWhere(new typeorm_2.Brackets((qb) => {
            qb.where('outletDetail.storeName LIKE :storeName', {
                storeName: '%' + keyword + '%',
            });
        }))
            .skip(dto.offset)
            .take(dto.limit)
            .orderBy({ 'outletDetail.storeName': 'ASC' })
            .getManyAndCount();
        return { result, total };
    }
    async findOrderId(id) {
        return this.repo
            .createQueryBuilder('outletDetail')
            .leftJoinAndSelect('outletDetail.outletBranch', 'outletBranch')
            .leftJoinAndSelect('outletBranch.companyDetail', 'companyDetail')
            .leftJoinAndSelect('outletDetail.area', 'area')
            .select([
            'outletDetail.id',
            'outletDetail.storeName',
            'outletBranch.id',
            'outletBranch.branchName',
            'companyDetail.id',
            'companyDetail.businessName',
            'area.id',
            'area.name',
        ])
            .where('outletDetail.accountId = :accountId', { accountId: id })
            .getOne();
    }
    async find(dto, branchId) {
        const keyword = dto.keyword || '';
        const [result, total] = await this.repo
            .createQueryBuilder('outletDetail')
            .leftJoinAndSelect('outletDetail.outletBranch', 'outletBranch')
            .leftJoinAndSelect('outletDetail.routeMaster', 'routeMaster')
            .leftJoinAndSelect('routeMaster.account', 'account')
            .leftJoinAndSelect('account.staffDetail', 'staffDetail')
            .leftJoinAndSelect('outletDetail.area', 'area')
            .leftJoinAndSelect('outletDetail.city', 'city')
            .leftJoinAndSelect('outletDetail.state', 'state')
            .where('outletDetail.outletBranchId = :outletBranchId AND outletDetail.status = :status', {
            outletBranchId: branchId,
            status: dto.status,
        })
            .andWhere(new typeorm_2.Brackets((qb) => {
            qb.where('outletDetail.storeName LIKE :storeName', {
                storeName: '%' + keyword + '%',
            });
        }))
            .skip(dto.offset)
            .take(dto.limit)
            .orderBy({ 'outletDetail.storeName': 'ASC' })
            .getManyAndCount();
        return { result, total };
    }
    async findOne(id) {
        const result = await this.repo.findOne({ where: { id } });
        if (!result) {
            throw new common_1.NotFoundException('Outlet not found!');
        }
        return result;
    }
    async outletProfile(id) {
        const result = await this.repo
            .createQueryBuilder('outletDetail')
            .leftJoinAndSelect('outletDetail.outletBranch', 'outletBranch')
            .leftJoinAndSelect('outletDetail.account', 'account')
            .leftJoinAndSelect('outletDetail.routeMaster', 'routeMaster')
            .leftJoinAndSelect('outletDetail.area', 'area')
            .leftJoinAndSelect('outletDetail.city', 'city')
            .leftJoinAndSelect('outletDetail.state', 'state')
            .where('outletDetail.id = :id', {
            id: id
        })
            .getOne();
        if (!result) {
            throw new common_1.NotFoundException('Profile not found!');
        }
        return result;
    }
    async update(id, dto) {
        const result = await this.repo.findOne({ where: { id } });
        if (!result) {
            throw new common_1.NotFoundException('Outlet not found!');
        }
        if (result.routeMasterId != dto.routeMasterId) {
            const object = Object.create({
                fromRoute: result.routeMasterId,
                toRoute: dto.routeMasterId,
                outletDetailId: result.id,
            });
            this.ralRepo.save(object);
        }
        const obj = Object.assign(result, dto);
        const payload = await this.repo.save(obj);
        return payload;
    }
    async status(id, dto) {
        const result = await this.repo.findOne({ where: { id } });
        if (!result) {
            throw new common_1.NotFoundException('Outlet not found!');
        }
        const obj = Object.assign(result, dto);
        return this.repo.save(obj);
    }
    async timeIncrease(id, dto) {
        const resultoutlet = await this.repo.findOne({ where: { id } });
        const resultacccount = await this.repo.findOne({
            relations: ['account'],
            where: { id },
        });
        if (!resultacccount) {
            throw new common_1.NotFoundException('Outlet not found!');
        }
        this.notifyService.timeIncreaseReply(resultacccount.account['fcm'], resultacccount.account['id'], resultoutlet.id);
        const obj = Object.assign(resultacccount, dto);
        return this.repo.save(obj);
    }
};
OutletDetailsService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(outlet_detail_entity_1.OutletDetail)),
    __param(1, (0, typeorm_1.InjectRepository)(route_assgin_log_entity_1.RouteAssginLog)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository,
        account_service_1.AccountService,
        notify_service_1.NotifyService])
], OutletDetailsService);
exports.OutletDetailsService = OutletDetailsService;
//# sourceMappingURL=outlet-details.service.js.map