import { AccountService } from 'src/account/account.service';
import { NotifyService } from 'src/notify/notify.service';
import { StatusDto } from 'src/outlet-branch/dto/outlet-branch.dto';
import { Repository } from 'typeorm';
import { CreateOutletDetailDto, OutletDetailDto, TimeIncreaseDto } from './dto/outlet-detail.dto';
import { OutletDetail } from './entities/outlet-detail.entity';
import { RouteAssginLog } from 'src/route-assgin-log/entities/route-assgin-log.entity';
export declare class OutletDetailsService {
    private readonly repo;
    private readonly ralRepo;
    private readonly accountService;
    private readonly notifyService;
    constructor(repo: Repository<OutletDetail>, ralRepo: Repository<RouteAssginLog>, accountService: AccountService, notifyService: NotifyService);
    create(dto: CreateOutletDetailDto, createdBy: string): Promise<any>;
    findAll(dto: any): Promise<{
        result: OutletDetail[];
        total: number;
    }>;
    findOrderId(id: string): Promise<OutletDetail>;
    find(dto: any, branchId: string): Promise<{
        result: OutletDetail[];
        total: number;
    }>;
    findOne(id: string): Promise<OutletDetail>;
    outletProfile(id: string): Promise<OutletDetail>;
    update(id: string, dto: OutletDetailDto): Promise<OutletDetail & OutletDetailDto>;
    status(id: string, dto: StatusDto): Promise<OutletDetail & StatusDto>;
    timeIncrease(id: string, dto: TimeIncreaseDto): Promise<OutletDetail & TimeIncreaseDto>;
}
