"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OutletBranchService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const outlet_branch_entity_1 = require("./entities/outlet-branch.entity");
let OutletBranchService = class OutletBranchService {
    constructor(repo) {
        this.repo = repo;
    }
    async create(dto) {
        const result = await this.repo.findOne({
            where: {
                branchName: dto.branchName,
                companyDetailId: dto.companyDetailId,
            },
        });
        if (result) {
            throw new common_1.ConflictException('Outlet already exists!');
        }
        const obj = Object.create(dto);
        return this.repo.save(obj);
    }
    async findAll(dto) {
        const keyword = dto.keyword || '';
        const [result, total] = await this.repo
            .createQueryBuilder('outletBranch')
            .leftJoinAndSelect('outletBranch.companyDetail', 'companyDetail')
            .leftJoinAndSelect('outletBranch.city', 'city')
            .leftJoinAndSelect('outletBranch.state', 'state')
            .where('outletBranch.status = :status', {
            status: dto.status,
        })
            .andWhere(new typeorm_2.Brackets((qb) => {
            qb.where('outletBranch.branchName LIKE :branchName', {
                branchName: '%' + keyword + '%',
            });
        }))
            .skip(dto.offset)
            .take(dto.limit)
            .orderBy({ 'outletBranch.branchName': 'ASC' })
            .getManyAndCount();
        return { result, total };
    }
    async find(dto, companyId) {
        const keyword = dto.keyword || '';
        const [result, total] = await this.repo
            .createQueryBuilder('outletBranch')
            .leftJoinAndSelect('outletBranch.companyDetail', 'companyDetail')
            .leftJoinAndSelect('outletBranch.city', 'city')
            .leftJoinAndSelect('outletBranch.state', 'state')
            .where('outletBranch.companyDetailId = :companyDetailId AND outletBranch.status = :status', {
            companyDetailId: companyId,
            status: dto.status,
        })
            .andWhere(new typeorm_2.Brackets((qb) => {
            qb.where('outletBranch.branchName LIKE :branchName', {
                branchName: '%' + keyword + '%',
            });
        }))
            .skip(dto.offset)
            .take(dto.limit)
            .orderBy({ 'outletBranch.branchName': 'ASC' })
            .getManyAndCount();
        return { result, total };
    }
    async findOne(id) {
        const result = await this.repo.findOne({ where: { id } });
        if (!result) {
            throw new common_1.NotFoundException('Outlet not found!');
        }
        return result;
    }
    async update(id, dto) {
        const result = await this.repo.findOne({ where: { id } });
        if (!result) {
            throw new common_1.NotFoundException('Outlet not found!');
        }
        const obj = Object.assign(result, dto);
        return this.repo.save(obj);
    }
    async status(id, dto) {
        const result = await this.repo.findOne({ where: { id } });
        if (!result) {
            throw new common_1.NotFoundException('Outlet not found!');
        }
        const obj = Object.assign(result, dto);
        return this.repo.save(obj);
    }
};
OutletBranchService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(outlet_branch_entity_1.OutletBranch)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], OutletBranchService);
exports.OutletBranchService = OutletBranchService;
//# sourceMappingURL=outlet-branch.service.js.map