import { Repository } from 'typeorm';
import { OutletBranchDto, PaginationSDto, StatusDto } from './dto/outlet-branch.dto';
import { OutletBranch } from './entities/outlet-branch.entity';
export declare class OutletBranchService {
    private readonly repo;
    constructor(repo: Repository<OutletBranch>);
    create(dto: OutletBranchDto): Promise<any>;
    findAll(dto: PaginationSDto): Promise<{
        result: OutletBranch[];
        total: number;
    }>;
    find(dto: PaginationSDto, companyId: string): Promise<{
        result: OutletBranch[];
        total: number;
    }>;
    findOne(id: string): Promise<OutletBranch>;
    update(id: string, dto: OutletBranchDto): Promise<OutletBranch & OutletBranchDto>;
    status(id: string, dto: StatusDto): Promise<OutletBranch & StatusDto>;
}
