"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OrdersService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const enum_1 = require("../enum");
const notify_service_1 = require("../notify/notify.service");
const outlet_details_service_1 = require("../outlet-details/outlet-details.service");
const typeorm_2 = require("typeorm");
const order_entity_1 = require("./entities/order.entity");
let OrdersService = class OrdersService {
    constructor(repo, outletDetailService, notifyService) {
        this.repo = repo;
        this.outletDetailService = outletDetailService;
        this.notifyService = notifyService;
    }
    async create(dto, outletDetailId) {
        const query = this.repo
            .createQueryBuilder('order')
            .where('order.outletDetailId = :outletDetailId AND order.subCategoryId = :subCategoryId AND order.status IN (:...status)', {
            outletDetailId,
            subCategoryId: dto.subCategoryId,
            status: [enum_1.OrderStatus.CART, enum_1.OrderStatus.ORDERED],
        });
        if (dto.cartId && dto.cartId.length > 3 && dto.cartId != 'null') {
            query.andWhere('order.cartId = :cartId', {
                cartId: dto.cartId,
            });
        }
        else {
            query.andWhere('order.cartId IS NULL');
        }
        const result = await query.getOne();
        if (result) {
            const obj = Object.assign(result, { quantity: dto.quantity });
            return this.repo.save(obj);
        }
        if (dto.cartId == 'null') {
            dto.cartId = null;
        }
        const obj = Object.create(dto);
        return this.repo.save(obj);
    }
    async update(date, dto, id, fcm) {
        let cartId = null;
        const curday = new Date();
        const activeObjects = dto.filter((item) => item.status === enum_1.OrderStatus.ORDERED);
        if (activeObjects.length > 0) {
            cartId = activeObjects[0].cartId;
        }
        else {
            const data = await this.outletDetailService.findOrderId(id);
            const storeName = await this.findFirstWords(data.storeName);
            const today = new Date();
            const day = await today.getDate().toString().padStart(2, '0');
            const areaName = await this.findFirstWords(data.area['name']);
            const randomNumber = (await Math.floor(Math.random() * (9999 - 1000 + 1))) + 1000;
            cartId = storeName + day + areaName + randomNumber;
        }
        const hasRemarks = dto.some(item => item.remark.trim() !== '');
        dto.forEach((element) => {
            element.cartId = cartId.toString();
            element.status = enum_1.OrderStatus.ORDERED;
            element.date = date;
            element.remarkStatus = hasRemarks;
            element.createdAt = curday;
        });
        console.log(dto);
        this.repo.save(dto);
        this.notifyService.orderPlaced(fcm, cartId, date, id);
        return { result: dto };
    }
    findFirstWords(a) {
        return a.match(/\b\w/g).join('').toUpperCase();
    }
    async updateQty(id, dto) {
        const order = await this.repo.findOne({ where: { id } });
        if (!order) {
            throw new common_1.NotFoundException('Order not found!');
        }
        const obj = Object.assign(order, dto);
        return this.repo.save(obj);
    }
    async remark(id, dto) {
        const order = await this.repo.findOne({ where: { id } });
        if (!order) {
            throw new common_1.NotFoundException('Order not found!');
        }
        const obj = Object.assign(order, dto);
        const result = await this.repo.save(obj);
        return { result };
    }
    async updateDeliveryBoy(cartId, accountId, status) {
        try {
            return this.repo
                .createQueryBuilder()
                .update()
                .set({
                status: status,
                accountId: accountId,
            })
                .where('cartId = :cartId', { cartId: cartId })
                .execute();
        }
        catch (error) {
            throw new common_1.NotAcceptableException('Invalid delivery boy id!');
        }
    }
    async signature(cartId, image) {
        try {
            this.repo
                .createQueryBuilder()
                .update()
                .set({
                signature: process.env.CDN_LINK + image,
                signaturePath: image,
            })
                .where('cartId = :cartId', { cartId: cartId })
                .execute();
            return { url: process.env.CDN_LINK + image };
        }
        catch (error) {
            throw new common_1.NotAcceptableException('Try after some time!');
        }
    }
    async returnProduct(id, image) {
        try {
            this.repo
                .createQueryBuilder()
                .update()
                .set({
                returnImage: process.env.CDN_LINK + image,
                returnImagePath: image,
            })
                .where('id = :id', { id: id })
                .execute();
            return { url: process.env.CDN_LINK + image };
        }
        catch (error) {
            throw new common_1.NotAcceptableException('Try after some time!');
        }
    }
    status(dto) {
        dto.forEach((element) => {
            if (element.delivered == 0) {
                element.status = enum_1.OrderStatus.RETURNED;
            }
            if (element.returned > 0) {
                element.status = enum_1.OrderStatus.PARTIALLY_DELIVERED;
            }
            if (element.returned == 0) {
                element.status = enum_1.OrderStatus.DELIVERED;
            }
        });
        this.repo.save(dto);
        return { result: dto };
    }
    async outletCartList(outletDetailId, dto) {
        const query = this.repo
            .createQueryBuilder('order')
            .leftJoinAndSelect('order.subCategory', 'subCategory')
            .leftJoinAndSelect('subCategory.category', 'category')
            .select([
            'order.id',
            'order.quantity',
            'order.returned',
            'order.delivered',
            'order.cartId',
            'order.status',
            'order.date',
            'order.reason',
            'order.remark',
            'order.createdAt',
            'subCategory.id',
            'subCategory.name',
            'subCategory.image',
            'category.id',
            'category.name',
        ])
            .where('order.outletDetailId = :outletDetailId', {
            outletDetailId: outletDetailId,
        });
        if (dto.cartId && dto.cartId.length > 3 && dto.cartId != 'null') {
            query.andWhere('order.cartId = :cartId', {
                cartId: dto.cartId,
            });
        }
        else {
            query.andWhere('order.cartId IS NULL');
        }
        const result = await query
            .andWhere('order.status IN (:...status1)', {
            status1: [enum_1.OrderStatus.CART, enum_1.OrderStatus.ORDERED],
        })
            .orderBy({ 'order.createdAt': 'DESC' })
            .getRawMany();
        return { result, total: result.length };
    }
    async adminOrderList(dto) {
        const keyword = dto.keyword || '';
        const fromDate = new Date(dto.fromDate);
        fromDate.setHours(0, 0, 0, 0);
        const toDate = new Date(dto.toDate);
        toDate.setHours(23, 59, 59, 59);
        const query = this.repo
            .createQueryBuilder('order')
            .leftJoinAndSelect('order.outletDetail', 'outletDetail')
            .leftJoinAndSelect('outletDetail.outletBranch', 'outletBranch')
            .leftJoinAndSelect('outletDetail.routeMaster', 'routeMaster')
            .leftJoinAndSelect('routeMaster.account', 'account')
            .leftJoinAndSelect('account.staffDetail', 'staffDetail')
            .leftJoinAndSelect('outletBranch.companyDetail', 'companyDetail')
            .select([
            'outletDetail.id',
            'outletDetail.storeName',
            'outletDetail.address',
            'routeMaster.id',
            'routeMaster.routeName',
            'account.id',
            'staffDetail.name',
            'outletBranch.id',
            'outletBranch.branchName',
            'companyDetail.id',
            'companyDetail.businessName',
            'order.id',
            'order.cartId',
            'order.status',
            'order.date',
            'order.createdAt',
            'order.remarkStatus'
        ]);
        if (keyword.length > 0) {
            query.andWhere(new typeorm_2.Brackets((qb) => {
                qb.where('companyDetail.businessName LIKE :cid and order.date >= :fromDate and order.date <= :toDate', {
                    cid: '%' + keyword + '%',
                    fromDate: fromDate,
                    toDate: toDate,
                });
            }));
        }
        else {
            query.where('order.date >= :fromDate and order.date <= :toDate', { fromDate: fromDate, toDate: toDate });
        }
        if (dto.status) {
            query.andWhere('order.status = :status', {
                status: dto.status,
            });
        }
        const [result, total] = await query
            .orderBy({ 'order.createdAt': 'DESC' })
            .groupBy('order.cartId')
            .take(dto.limit)
            .skip(dto.offset)
            .getManyAndCount();
        return { result, total };
    }
    async adminOrderReport(dto) {
        const keyword = dto.keyword || '';
        const fromDate = dto.fromDate;
        const toDate = dto.toDate;
        const categoryName = dto.categoryName;
        const cartId = JSON.parse(dto.allorder);
        const query = this.repo
            .createQueryBuilder('order')
            .leftJoinAndSelect('order.subCategory', 'subCategory')
            .leftJoinAndSelect('subCategory.category', 'category')
            .leftJoinAndSelect('order.outletDetail', 'outletDetail')
            .leftJoinAndSelect('outletDetail.outletBranch', 'outletBranch')
            .leftJoinAndSelect('outletDetail.routeMaster', 'routeMaster')
            .leftJoinAndSelect('outletBranch.companyDetail', 'companyDetail')
            .select([
            'outletDetail.id',
            'outletDetail.storeName',
            'outletDetail.address',
            'order.id',
            'order.cartId',
            'order.status',
            'order.date',
            'order.quantity',
            'order.delivered',
            'order.returned',
            'order.reason',
            'order.remark',
            'order.createdAt',
            'subCategory.id',
            'subCategory.name',
            'subCategory.image',
            'subCategory.foodType',
            'category.id',
            'category.name',
            'outletBranch.id',
            'outletBranch.branchName',
            'companyDetail.id',
            'companyDetail.businessName',
            "routeMaster.id",
            "routeMaster.routeName",
            "routeMaster.startPoint",
            "routeMaster.endPoint",
        ]);
        query.where('order.date >= :fromDate and order.date <= :toDate and order.status = :status', { fromDate: fromDate, toDate: toDate, status: 'ORDERED' });
        if (categoryName !== 'All') {
            query.andWhere('category.name = :categoryName', { categoryName: categoryName });
        }
        if (keyword.length > 0) {
            query.andWhere(new typeorm_2.Brackets((qb) => {
                qb.where('companyDetail.businessName LIKE :cid', {
                    cid: '%' + keyword + '%',
                });
            }));
        }
        if (cartId.length > 0) {
            query.andWhere('order.cartId IN (:...cartId)', {
                cartId: [cartId],
            });
        }
        const result = await query
            .orderBy({ 'order.createdAt': 'DESC' })
            .take(dto.limit)
            .skip(dto.offset)
            .getRawMany();
        return { result };
    }
    async findReportAll(dto) {
        const fromDate = new Date(dto.fromDate);
        fromDate.setHours(0, 0, 0, 0);
        const toDate = new Date(dto.toDate);
        toDate.setHours(23, 59, 59, 59);
        const query = this.repo
            .createQueryBuilder('order')
            .leftJoinAndSelect('order.outletDetail', 'outletDetail')
            .select([
            'outletDetail.id',
            'outletDetail.storeName',
            'order.id',
            'order.outletDetailId',
            'SUM(order.quantity) AS totalQuantity',
            'SUM(order.delivered) AS totalDelivered',
            'SUM(order.returned) AS totalReturned',
            'order.createdAt',
        ]);
        query.where('order.createdAt >= :fromDate and order.createdAt <= :toDate', { fromDate: fromDate, toDate: toDate });
        const result = await query
            .orderBy({ 'order.createdAt': 'DESC' })
            .groupBy('order.outletDetailId')
            .take(dto.limit)
            .skip(dto.offset)
            .getRawMany();
        const total = await query.getCount();
        return { result, total };
    }
    async outletOrderList(outletDetailId, dto) {
        const keyword = dto.keyword || '';
        const fromDate = new Date(dto.fromDate);
        fromDate.setHours(0, 0, 0, 0);
        const toDate = new Date(dto.toDate);
        toDate.setHours(23, 59, 59, 59);
        const query = this.repo
            .createQueryBuilder('order')
            .leftJoinAndSelect('order.subCategory', 'subCategory')
            .leftJoinAndSelect('subCategory.category', 'category')
            .leftJoinAndSelect('order.outletDetail', 'outletDetail')
            .select([
            'outletDetail.id',
            'outletDetail.storeName',
            'outletDetail.address',
            'order.id',
            'order.cartId',
            'order.status',
            'order.tistatus',
            'order.date',
            'order.createdAt',
        ])
            .where('order.outletDetailId = :outletDetailId AND order.status != :status', {
            outletDetailId: outletDetailId,
            status: enum_1.OrderStatus.CART,
        })
            .andWhere(new typeorm_2.Brackets((qb) => {
            qb.where('order.id LIKE :oid OR order.cartId LIKE :cid', {
                oid: '%' + keyword + '%',
                cid: '%' + keyword + '%',
            });
        }));
        if (dto.fromDate && dto.toDate) {
            query.andWhere('order.date >= :fromDate and order.date <= :toDate', {
                fromDate: fromDate,
                toDate: toDate,
            });
        }
        const [result, total] = await query
            .orderBy({ 'order.createdAt': 'DESC' })
            .groupBy('order.cartId')
            .getManyAndCount();
        return { result, total };
    }
    async outletOrderItems(cartId) {
        const [result, total] = await this.repo
            .createQueryBuilder('order')
            .leftJoinAndSelect('order.subCategory', 'subCategory')
            .leftJoinAndSelect('subCategory.category', 'category')
            .leftJoinAndSelect('order.outletDetail', 'outletDetail')
            .select([
            'outletDetail.id',
            'outletDetail.storeName',
            'outletDetail.address',
            'order.id',
            'order.quantity',
            'order.returned',
            'order.delivered',
            'order.cartId',
            'order.status',
            'order.date',
            'order.reason',
            'order.remark',
            'order.createdAt',
            'subCategory.id',
            'subCategory.name',
            'subCategory.image',
            'category.id',
            'category.name',
        ])
            .where('order.cartId = :cartId AND order.status IN (:...status)', {
            cartId: cartId,
            status: [
                enum_1.OrderStatus.ORDERED,
                enum_1.OrderStatus.DISPATCHED,
                enum_1.OrderStatus.DELIVERED,
                enum_1.OrderStatus.PARTIALLY_DELIVERED,
                enum_1.OrderStatus.RETURNED,
                enum_1.OrderStatus.DELETED,
            ],
        })
            .orderBy({ 'order.createdAt': 'DESC' })
            .getManyAndCount();
        return { result, total };
    }
    async printOrderItems(cartId) {
        const [result, total] = await this.repo
            .createQueryBuilder('order')
            .leftJoinAndSelect('order.subCategory', 'subCategory')
            .leftJoinAndSelect('subCategory.category', 'category')
            .leftJoinAndSelect('order.outletDetail', 'outletDetail')
            .select([
            'outletDetail.id',
            'outletDetail.outletId',
            'outletDetail.storeName',
            'outletDetail.address',
            'order.id',
            'order.quantity',
            'order.returned',
            'order.delivered',
            'order.cartId',
            'order.status',
            'order.date',
            'order.reason',
            'order.remark',
            'order.createdAt',
            'subCategory.id',
            'subCategory.name',
            'subCategory.image',
            'category.id',
            'category.name',
        ])
            .where('order.cartId = :cartId', {
            cartId: cartId,
        })
            .orderBy({ 'order.createdAt': 'DESC' })
            .getManyAndCount();
        return { result, total };
    }
    async findGroupByDelivery(accountId, dto) {
        const keyword = dto.keyword || '';
        const [result, total] = await this.repo
            .createQueryBuilder('order')
            .leftJoinAndSelect('order.outletDetail', 'outletDetail')
            .leftJoinAndSelect('outletDetail.outletBranch', 'outletBranch')
            .select([
            'outletDetail.id',
            'outletDetail.outletId',
            'outletDetail.storeName',
            'outletDetail.contactPerson',
            'outletDetail.address',
            'outletDetail.orderOpenTime',
            'outletDetail.orderCloseTime',
            'outletDetail.contact',
            'outletDetail.latitude',
            'outletDetail.longitude',
            'outletBranch.id',
            'outletBranch.phone',
            'outletBranch.branchName',
            'outletBranch.logo',
            'order.id',
            'order.cartId',
            'order.date',
            'order.status',
            'order.createdAt',
        ])
            .where('order.accountId = :accountId AND order.status IN (:...status)', {
            accountId: accountId,
            status: [enum_1.OrderStatus.DISPATCHED],
        })
            .andWhere(new typeorm_2.Brackets((qb) => {
            qb.where('order.id LIKE :oid OR order.cartId LIKE :cid', {
                oid: '%' + keyword + '%',
                cid: '%' + keyword + '%',
            });
        }))
            .orderBy({ 'order.createdAt': 'DESC' })
            .groupBy('order.cartId')
            .getManyAndCount();
        return { result, total };
    }
    async findGroupDeliveryHistory(accountId, dto) {
        const keyword = dto.keyword || '';
        const fromDate = new Date(dto.fromDate);
        fromDate.setHours(0, 0, 0, 0);
        const toDate = new Date(dto.toDate);
        toDate.setHours(23, 59, 59, 59);
        const query = this.repo
            .createQueryBuilder('order')
            .leftJoinAndSelect('order.outletDetail', 'outletDetail')
            .leftJoinAndSelect('outletDetail.outletBranch', 'outletBranch')
            .select([
            'outletDetail.id',
            'outletDetail.outletId',
            'outletDetail.storeName',
            'outletDetail.contactPerson',
            'outletDetail.address',
            'outletDetail.orderOpenTime',
            'outletDetail.orderCloseTime',
            'outletDetail.contact',
            'outletDetail.latitude',
            'outletDetail.longitude',
            'outletBranch.id',
            'outletBranch.branchName',
            'order.id',
            'order.cartId',
            'order.status',
            'order.date',
            'order.createdAt',
        ])
            .where('order.accountId = :accountId AND order.status IN (:...status)', {
            accountId: accountId,
            status: [
                enum_1.OrderStatus.DELIVERED,
                enum_1.OrderStatus.PARTIALLY_DELIVERED,
                enum_1.OrderStatus.RETURNED,
            ],
        })
            .andWhere(new typeorm_2.Brackets((qb) => {
            qb.where('order.id LIKE :oid OR order.cartId LIKE :cid', {
                oid: '%' + keyword + '%',
                cid: '%' + keyword + '%',
            });
        }));
        if (dto.fromDate && dto.toDate) {
            query.andWhere('order.date >= :fromDate and order.date <= :toDate', {
                fromDate: fromDate,
                toDate: toDate,
            });
        }
        const [result, total] = await query
            .orderBy({ 'order.createdAt': 'DESC' })
            .groupBy('order.cartId')
            .getManyAndCount();
        return { result, total };
    }
    async findOne(id) {
        const order = await this.repo.findOne({ where: { id } });
        if (!order) {
            throw new common_1.NotFoundException('Order not found!');
        }
        return order;
    }
    async removeorders(id) {
        const resultdata = await this.repo.find({ where: { cartId: id } });
        resultdata.forEach(async (element) => {
            const obj = Object.assign(element, { status: enum_1.OrderStatus.REJECTED });
            this.repo.save(obj);
        });
    }
    async removesingle(id) {
        const result = await this.repo.findOne({ where: { id } });
        if (!result) {
            throw new common_1.NotFoundException('Not found!');
        }
        const obj = Object.assign(result, { status: enum_1.OrderStatus.DELETED });
        return this.repo.save(obj);
    }
};
OrdersService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(order_entity_1.Order)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        outlet_details_service_1.OutletDetailsService,
        notify_service_1.NotifyService])
], OrdersService);
exports.OrdersService = OrdersService;
//# sourceMappingURL=orders.service.js.map