/// <reference types="multer" />
import { Account } from 'src/account/entities/account.entity';
import { DeliveryBoyDto, JsonOrderDto, OrderDto, OrderJsonDto, PaginationAllDto, PaginationAllReportDto, PaginationReportDto, PaginationDto, RemarkDto, SearchListDto, StatusDto, StatusOrderDto } from './dto/order.dto';
import { OrdersService } from './orders.service';
export declare class OrdersController {
    private readonly ordersService;
    constructor(ordersService: OrdersService);
    create(dto: OrderDto, user: Account): Promise<any>;
    adminOrderList(query: PaginationAllDto): Promise<{
        result: import("./entities/order.entity").Order[];
        total: number;
    }>;
    adminOrderReport(query: PaginationAllReportDto): Promise<{
        result: any[];
    }>;
    findReportAll(dto: PaginationReportDto): Promise<{
        result: any[];
        total: number;
    }>;
    outletCartList(user: Account, dto: StatusDto): Promise<{
        result: any[];
        total: number;
    }>;
    outletOrderList(user: Account, query: PaginationDto): Promise<{
        result: import("./entities/order.entity").Order[];
        total: number;
    }>;
    outletOrderItems(cartId: string): Promise<{
        result: import("./entities/order.entity").Order[];
        total: number;
    }>;
    printOrderItems(cartId: string): Promise<{
        result: import("./entities/order.entity").Order[];
        total: number;
    }>;
    deliveryBoyHistory(user: Account, query: PaginationDto): Promise<{
        result: import("./entities/order.entity").Order[];
        total: number;
    }>;
    deliveryBoyList(user: Account, dto: SearchListDto): Promise<{
        result: import("./entities/order.entity").Order[];
        total: number;
    }>;
    findOne(id: string): Promise<import("./entities/order.entity").Order>;
    update(dto: OrderJsonDto, user: Account): Promise<{
        result: import("./dto/order.dto").UpdateOrderDto[];
    }>;
    assignDeliveryBoy(cartId: string, dto: DeliveryBoyDto): Promise<import("typeorm").UpdateResult>;
    updateQty(id: string, dto: StatusOrderDto): Promise<import("./entities/order.entity").Order & StatusOrderDto>;
    remark(id: string, dto: RemarkDto): Promise<{
        result: import("./entities/order.entity").Order & RemarkDto;
    }>;
    image1(id: string, file: Express.Multer.File): Promise<{
        url: string;
    }>;
    image2(cartId: string, file: Express.Multer.File): Promise<{
        url: string;
    }>;
    status(dto: JsonOrderDto): {
        result: StatusOrderDto[];
    };
    removeorders(id: string): Promise<void>;
    removesingle(id: string): Promise<import("./entities/order.entity").Order & {
        status: import("src/enum").OrderStatus;
    }>;
}
