import { OrderStatus } from 'src/enum';
export declare class OrderDto {
    subCategoryId: string;
    quantity: number;
    outletDetailId: string;
    cartId: string;
}
export declare class UpdateOrderDto {
    id: string;
    subCategoryId: string;
    quantity: number;
    remark: string;
    cartId: string;
    status: OrderStatus;
    date: Date;
    remarkStatus: boolean;
    createdAt: Date;
}
export declare class OrderJsonDto {
    data: UpdateOrderDto[];
    date: Date;
    status: boolean;
}
export declare class StatusOrderDto {
    id: string;
    quantity: number;
    delivered: number;
    returned: number;
    reason: string;
    status: OrderStatus;
}
export declare class JsonOrderDto {
    data: StatusOrderDto[];
}
export declare class UpdateOrderQtyDto {
    id: string;
    delivered: number;
    returned: number;
    reason: string;
}
export declare class StatusDto {
    cartId: string;
}
export declare class RemarkDto {
    remark: string;
}
export declare class PaginationDto {
    limit: number;
    offset: number;
    keyword: string;
    fromDate: Date;
    toDate: Date;
}
export declare class SearchListDto {
    keyword: string;
}
export declare class DeliveryBoyDto {
    accountId: string;
    status: OrderStatus;
}
export declare class PaginationAllDto {
    limit: number;
    offset: number;
    keyword: string;
    status: OrderStatus;
    fromDate: Date;
    toDate: Date;
}
export declare class PaginationAllReportDto {
    limit: number;
    offset: number;
    keyword: string;
    status: OrderStatus;
    fromDate: Date;
    toDate: Date;
    categoryName: string;
    allorder: string;
}
export declare class PaginationReportDto {
    limit: number;
    offset: number;
    fromDate: Date;
    toDate: Date;
}
