"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotifyService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const enum_1 = require("../enum");
const notification_entity_1 = require("../notifications/entities/notification.entity");
const order_entity_1 = require("../orders/entities/order.entity");
const notify_utils_1 = require("../utils/notify.utils");
const typeorm_2 = require("typeorm");
let NotifyService = class NotifyService {
    constructor(repo, oRepo) {
        this.repo = repo;
        this.oRepo = oRepo;
    }
    async loginNotify(fcm, accountId) {
        (0, notify_utils_1.sendNotifications)(fcm, 'Thanks for login', 'Thanks for login, Now you can order from our App.');
        this.saveNotification({
            title: 'Thanks for login',
            desc: 'Thanks for login, Now you can order from our App.',
            type: enum_1.NotificationType.ACCOUNT,
            redirectId: null,
            accountId: accountId,
        });
    }
    async loginDeliveryBoyNotify(fcm, accountId) {
        (0, notify_utils_1.sendNotifications)(fcm, 'Thanks for login', 'Thanks for login, Now you can check orders list for delivery.');
        this.saveNotification({
            title: 'Thanks for login',
            desc: 'Thanks for login, Now you can check orders list for delivery.',
            type: enum_1.NotificationType.ACCOUNT,
            redirectId: null,
            accountId: accountId,
        });
    }
    async loginBlockedNotify(fcm, accountId) {
        (0, notify_utils_1.sendNotifications)(fcm, 'Blocked', 'Your login is suspended by App Admin kindly contact to admin and resolve it.');
        this.saveNotification({
            title: 'Blocked',
            desc: 'Your login is suspended by App Admin kindly contact to admin and resolve it.',
            type: enum_1.NotificationType.ACCOUNT,
            redirectId: null,
            accountId: accountId,
        });
    }
    async outOfLocationNotify(fcm, accountId) {
        (0, notify_utils_1.sendNotifications)(fcm, 'Out of location', 'Hey we observe, you are not in Outlet. Please login from outlet Only.');
        this.saveNotification({
            title: 'Out of location',
            desc: 'Hey we observe, you are not in Outlet. Please login from outlet Only.',
            type: enum_1.NotificationType.ACCOUNT,
            redirectId: null,
            accountId: accountId,
        });
        return { result: 'true' };
    }
    async raiseTicket(fcm, accountId) {
        (0, notify_utils_1.sendNotifications)(fcm, 'Concern raised', 'Thanks for raising your concern, We are very excited to resolve your concern.');
        this.saveNotification({
            title: 'Concern raised',
            desc: 'Thanks for raising your concern, We are very excited to resolve your concern.',
            type: enum_1.NotificationType.ACCOUNT,
            redirectId: null,
            accountId: accountId,
        });
    }
    async timeIncrease(fcm, outletDetailId, cartId) {
        (0, notify_utils_1.sendNotifications)(fcm, 'Time Increase', 'Thanks for raising your concern, We are very excited to resolve your concern.');
        this.saveNotification({
            title: 'Time Increase',
            desc: 'Thanks for raising your concern, We are very excited to resolve your concern.',
            type: enum_1.NotificationType.TIME_INCREMENT,
            redirectId: outletDetailId,
            accountId: null,
        });
        this.oRepo
            .createQueryBuilder()
            .update()
            .set({
            tistatus: true,
        })
            .where('cartId = :cartId', { cartId: cartId })
            .execute();
        return { result: 'true' };
    }
    async timeIncreaseOutlet(fcm, outletDetailId) {
        (0, notify_utils_1.sendNotifications)(fcm, 'Time Increase', 'Thanks for raising your concern, We are very excited to resolve your concern.');
        this.saveNotification({
            title: 'Time Increase',
            desc: 'Thanks for raising your concern, We are very excited to resolve your concern.',
            type: enum_1.NotificationType.TIME_INCREMENT,
            redirectId: outletDetailId,
            accountId: null,
        });
        return { result: 'true' };
    }
    async timeIncreaseReply(fcm, accountId, outletDetailId) {
        (0, notify_utils_1.sendNotifications)(fcm, 'Time Increase', 'Thanks for raising your concern, We are very excited to resolve your concern.');
        this.saveNotification({
            title: 'Time Increase',
            desc: 'Thanks for raising your concern, We are very excited to resolve your concern.',
            type: enum_1.NotificationType.TIME_INCREMENT,
            redirectId: outletDetailId,
            accountId: accountId,
        });
    }
    async orderPlaced(fcm, orderId, date, accountId) {
        var fullDate = new Date(date);
        var tDate = fullDate.getDate();
        var tYear = fullDate.getFullYear();
        var tMonth = fullDate.getMonth() + 1;
        const delivery_date = tDate + '-' + tMonth + '-' + tYear;
        (0, notify_utils_1.sendNotifications)(fcm, 'Order Placed', 'Thanks for your order, your order ' +
            orderId +
            ' we will deliver your order ' +
            delivery_date +
            '.');
        this.saveNotification({
            title: 'Order Placed',
            desc: 'Thanks for your order, your order ' +
                orderId +
                ' we will deliver your order ' +
                delivery_date +
                '.',
            type: enum_1.NotificationType.ORDER,
            redirectId: orderId,
            accountId: accountId,
        });
    }
    async orderConfirmed(fcm, orderId, date, accountId) {
        (0, notify_utils_1.sendNotifications)(fcm, 'Order Confirmed', 'Hey thanks for placing order ' +
            orderId +
            ' we will delivery order on dated ' +
            date +
            '.');
        this.saveNotification({
            title: 'Order Confirmed',
            desc: 'Hey thanks for placing order ' +
                orderId +
                ' we will delivery order on dated ' +
                date +
                '.',
            type: enum_1.NotificationType.ORDER,
            redirectId: orderId,
            accountId: accountId,
        });
    }
    async lateOrderConfirmed(fcm, orderId, accountId) {
        (0, notify_utils_1.sendNotifications)(fcm, 'Order Confirmed', 'Hey thanks for placing order we will notify you once order confirm from Base Kitchen your order Number ' +
            orderId +
            '.');
        this.saveNotification({
            title: 'Order Confirmed',
            desc: 'Hey thanks for placing order we will notify you once order confirm from Base Kitchen your order Number ' +
                orderId +
                '.',
            type: enum_1.NotificationType.ORDER,
            redirectId: orderId,
            accountId: accountId,
        });
    }
    async orderChanges(fcm, orderId, accountId) {
        (0, notify_utils_1.sendNotifications)(fcm, 'Order Change', 'Thanks for making the changes in order will notify to base kitchen.');
        this.saveNotification({
            title: 'Order Change',
            desc: 'Thanks for making the changes in order will notify to base kitchen.',
            type: enum_1.NotificationType.ORDER,
            redirectId: orderId,
            accountId: accountId,
        });
    }
    async orderBeforeTime(fcm, orderId, accountId) {
        (0, notify_utils_1.sendNotifications)(fcm, 'Order Change', 'Hey you can edit order you have 30 min left time.');
        this.saveNotification({
            title: 'Order Change',
            desc: 'Hey you can edit order you have 30 min left time.',
            type: enum_1.NotificationType.ORDER,
            redirectId: orderId,
            accountId: accountId,
        });
    }
    async appMaintenance() {
        (0, notify_utils_1.sendBulkNotifications)('App under maintenance', 'Hey we We put our app in maintenance for app upgradation.');
        this.saveNotification({
            title: 'App under maintenance',
            desc: 'Hey we We put our app in maintenance for app upgradation.',
            type: enum_1.NotificationType.MAINTENANCE,
            redirectId: null,
            accountId: null,
        });
    }
    saveNotification(dto) {
        return this.repo.save(dto);
    }
};
NotifyService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(notification_entity_1.Notification)),
    __param(1, (0, typeorm_1.InjectRepository)(order_entity_1.Order)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository])
], NotifyService);
exports.NotifyService = NotifyService;
//# sourceMappingURL=notify.service.js.map