import { Notification } from 'src/notifications/entities/notification.entity';
import { Order } from 'src/orders/entities/order.entity';
import { Repository } from 'typeorm';
export declare class NotifyService {
    private readonly repo;
    private readonly oRepo;
    constructor(repo: Repository<Notification>, oRepo: Repository<Order>);
    loginNotify(fcm: string, accountId: string): Promise<void>;
    loginDeliveryBoyNotify(fcm: string, accountId: string): Promise<void>;
    loginBlockedNotify(fcm: string, accountId: string): Promise<void>;
    outOfLocationNotify(fcm: string, accountId: string): Promise<{
        result: string;
    }>;
    raiseTicket(fcm: string, accountId: string): Promise<void>;
    timeIncrease(fcm: string, outletDetailId: string, cartId: string): Promise<{
        result: string;
    }>;
    timeIncreaseOutlet(fcm: string, outletDetailId: string): Promise<{
        result: string;
    }>;
    timeIncreaseReply(fcm: string, accountId: string, outletDetailId: string): Promise<void>;
    orderPlaced(fcm: string, orderId: string, date: string, accountId: string): Promise<void>;
    orderConfirmed(fcm: string, orderId: string, date: string, accountId: string): Promise<void>;
    lateOrderConfirmed(fcm: string, orderId: string, accountId: string): Promise<void>;
    orderChanges(fcm: string, orderId: string, accountId: string): Promise<void>;
    orderBeforeTime(fcm: string, orderId: string, accountId: string): Promise<void>;
    appMaintenance(): Promise<void>;
    private saveNotification;
}
