"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CronNotifyService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const schedule = require("node-schedule");
const enum_1 = require("../enum");
const notification_entity_1 = require("../notifications/entities/notification.entity");
const outlet_detail_entity_1 = require("../outlet-details/entities/outlet-detail.entity");
const notify_utils_1 = require("../utils/notify.utils");
const typeorm_2 = require("typeorm");
let CronNotifyService = class CronNotifyService {
    constructor(repo, orepo) {
        this.repo = repo;
        this.orepo = orepo;
        this.oneHourBefore();
    }
    async oneHourBefore() {
        schedule.scheduleJob({ hour: 21, minute: 30, tz: 'Asia/Kolkata' }, async () => {
            try {
                const result = await this.orepo
                    .createQueryBuilder('outletDetail')
                    .leftJoinAndSelect('outletDetail.account', 'account')
                    .select([
                    'outletDetail.id',
                    'outletDetail.storeName',
                    'outletDetail.orderCloseTime',
                    'outletDetail.orderOpenTime',
                    'account.id',
                    'account.fcm',
                ])
                    .getMany();
                for (let index = 0; index < result.length; index++) {
                    const closeTime = result[index].orderCloseTime;
                    const outletName = result[index].storeName;
                    const fcm = result[index].account['fcm'];
                    const accountId = result[index].account['id'];
                    const [openHours, openMinutes] = result[index].orderOpenTime
                        .toString()
                        .split(':')
                        .map(Number);
                    const [closeHours, closeMinutes] = result[index].orderCloseTime
                        .toString()
                        .split(':')
                        .map(Number);
                    this.orderOpenTime60Before(openHours, openMinutes, fcm, outletName, accountId);
                    this.orderOpenTime30Before(openHours, openMinutes, fcm, outletName, accountId);
                    this.orderOpenTimeNow(openHours, openMinutes, fcm, outletName, closeTime, accountId);
                    this.orderCloseTime60After(closeHours, closeMinutes, fcm, outletName, closeTime, accountId);
                    this.orderCloseTime15After(closeHours, closeMinutes, fcm, outletName, closeTime, accountId);
                }
            }
            catch (error) {
                console.error('Error occurred in the scheduled job:', error);
            }
        });
    }
    async orderOpenTime60Before(hours, minutes, fcm, outletName, accountId) {
        const jobRule = new schedule.RecurrenceRule();
        const currentTime = new Date();
        currentTime.setHours(hours);
        currentTime.setMinutes(minutes);
        currentTime.setMinutes(currentTime.getMinutes() - 60);
        jobRule.hour = currentTime.getHours();
        jobRule.minute = currentTime.getMinutes();
        jobRule.tz = 'Asia/Kolkata';
        schedule.scheduleJob(jobRule, () => {
            (0, notify_utils_1.sendNotifications)(fcm, 'Order Open Time', 'Hey ' +
                outletName +
                ' Your order is opening in 60 Min. Check your Order & add in bucket.');
            this.saveNotification({
                title: 'Order Open Time',
                desc: 'Hey ' +
                    outletName +
                    ' Your order is opening in 60 Min. Check your Order & add in bucket.',
                type: enum_1.NotificationType.ORDER,
                redirectId: null,
                accountId,
            });
        });
    }
    async orderOpenTime30Before(hours, minutes, fcm, outletName, accountId) {
        const jobRule = new schedule.RecurrenceRule();
        const currentTime = new Date();
        currentTime.setHours(hours);
        currentTime.setMinutes(minutes);
        currentTime.setMinutes(currentTime.getMinutes() - 30);
        jobRule.hour = currentTime.getHours();
        jobRule.minute = currentTime.getMinutes();
        jobRule.tz = 'Asia/Kolkata';
        schedule.scheduleJob(jobRule, () => {
            (0, notify_utils_1.sendNotifications)(fcm, 'Order Open Time', 'Hey ' +
                outletName +
                ' Your order is opening in 30 Min. Check your Order & add in bucket.');
            this.saveNotification({
                title: 'Order Open Time',
                desc: 'Hey ' +
                    outletName +
                    ' Your order is opening in 30 Min. Check your Order & add in bucket.',
                type: enum_1.NotificationType.ORDER,
                redirectId: null,
                accountId,
            });
        });
    }
    async orderOpenTimeNow(hours, minutes, fcm, outletName, closeTime, accountId) {
        const jobRule = new schedule.RecurrenceRule();
        const currentTime = new Date();
        currentTime.setHours(hours);
        currentTime.setMinutes(minutes);
        currentTime.setMinutes(currentTime.getMinutes());
        jobRule.hour = currentTime.getHours();
        jobRule.minute = currentTime.getMinutes();
        jobRule.tz = 'Asia/Kolkata';
        schedule.scheduleJob(jobRule, () => {
            (0, notify_utils_1.sendNotifications)(fcm, 'Order Open Now', 'Hey ' +
                outletName +
                ' Your order is open till ' +
                closeTime +
                '. Place your order now.');
            this.saveNotification({
                title: 'Order Open Now',
                desc: 'Hey ' +
                    outletName +
                    ' Your order is open till ' +
                    closeTime +
                    '. Place your order now.',
                type: enum_1.NotificationType.ORDER,
                redirectId: null,
                accountId,
            });
        });
    }
    async orderCloseTime60After(hours, minutes, fcm, outletName, closeTime, accountId) {
        const jobRule = new schedule.RecurrenceRule();
        const currentTime = new Date();
        currentTime.setHours(hours);
        currentTime.setMinutes(minutes);
        currentTime.setMinutes(currentTime.getMinutes() - 60);
        jobRule.hour = currentTime.getHours();
        jobRule.minute = currentTime.getMinutes();
        jobRule.tz = 'Asia/Kolkata';
        schedule.scheduleJob(jobRule, () => {
            (0, notify_utils_1.sendNotifications)(fcm, 'Order Closing Time', 'Hey ' +
                outletName +
                ' Your order is closing soon in  ' +
                closeTime +
                '. Place your order now.');
            this.saveNotification({
                title: 'Order Closing Time',
                desc: 'Hey ' +
                    outletName +
                    ' Your order is closing soon in  ' +
                    closeTime +
                    '. Place your order now.',
                type: enum_1.NotificationType.ORDER,
                redirectId: null,
                accountId,
            });
        });
    }
    async orderCloseTime15After(hours, minutes, fcm, outletName, closeTime, accountId) {
        const jobRule = new schedule.RecurrenceRule();
        const currentTime = new Date();
        currentTime.setHours(hours);
        currentTime.setMinutes(minutes);
        currentTime.setMinutes(currentTime.getMinutes() - 15);
        jobRule.hour = currentTime.getHours();
        jobRule.minute = currentTime.getMinutes();
        jobRule.tz = 'Asia/Kolkata';
        schedule.scheduleJob(jobRule, () => {
            (0, notify_utils_1.sendNotifications)(fcm, 'Order Closing Time', 'Hey ' +
                outletName +
                ' Your order is closing soon in  ' +
                closeTime +
                '. Place your order now.');
            this.saveNotification({
                title: 'Order Closing Time',
                desc: 'Hey ' +
                    outletName +
                    ' Your order is closing soon in  ' +
                    closeTime +
                    '. Place your order now.',
                type: enum_1.NotificationType.ORDER,
                redirectId: null,
                accountId,
            });
        });
    }
    saveNotification(dto) {
        return this.repo.save(dto);
    }
};
CronNotifyService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(notification_entity_1.Notification)),
    __param(1, (0, typeorm_1.InjectRepository)(outlet_detail_entity_1.OutletDetail)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository])
], CronNotifyService);
exports.CronNotifyService = CronNotifyService;
//# sourceMappingURL=cron-notify.service.js.map