"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotificationsService = void 0;
const axios_1 = require("@nestjs/axios");
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const enum_1 = require("../enum");
const typeorm_2 = require("typeorm");
const notification_entity_1 = require("./entities/notification.entity");
const outlet_detail_entity_1 = require("../outlet-details/entities/outlet-detail.entity");
let NotificationsService = class NotificationsService {
    constructor(repo, repolet, httpService) {
        this.repo = repo;
        this.repolet = repolet;
        this.httpService = httpService;
    }
    async sendBulkNotification(body, title, token, status) {
        const header = {
            headers: {
                'cache-control': 'no-cache',
                authorization: 'key=' + process.env.NOTIFY_AUTH,
                'content-type': 'application/json',
            },
        };
        let data = null;
        if (status) {
            data = JSON.stringify({
                registration_ids: token,
                data: { body: body, title: title, sound: 'default', type: 1 },
                notification: { body: body, title: title, sound: 'default', type: 1 },
            });
        }
        else {
            data = JSON.stringify({
                to: token,
                data: { body: body, title: title, sound: 'default', type: 1 },
                notification: { body: body, title: title, sound: 'default', type: 1 },
            });
        }
        try {
            const result = await this.httpService.axiosRef.post(`https://fcm.googleapis.com/fcm/send`, data, header);
            if (result.data) {
                return result.data;
            }
        }
        catch (error) {
            return false;
        }
    }
    async create(createDto) {
        const result = await this.repo.count({
            where: {
                title: createDto.title,
                desc: createDto.desc,
                type: createDto.type,
                accountId: createDto.accountId,
            },
        });
        if (!result) {
            return this.repo.save(createDto);
        }
        else {
            return true;
        }
    }
    async findAll(limit, offset, accountId) {
        const [result, total] = await this.repo
            .createQueryBuilder('notification')
            .leftJoinAndSelect('notification.account', 'account')
            .where('notification.accountId = :accountId', {
            accountId: accountId,
        })
            .skip(offset)
            .take(limit)
            .orderBy({ 'notification.createdAt': 'DESC' })
            .getManyAndCount();
        return { result, total };
    }
    async findAllForAdmin(limit, offset) {
        const [payload, total] = await this.repo
            .createQueryBuilder('notification')
            .leftJoinAndSelect('notification.account', 'account')
            .where('notification.type IN (:...type)', {
            type: [
                enum_1.NotificationType.CONTACT_US,
                enum_1.NotificationType.TICKET,
                enum_1.NotificationType.TIME_INCREMENT,
            ],
        })
            .skip(offset)
            .take(limit)
            .orderBy({ 'notification.createdAt': 'DESC' })
            .getManyAndCount();
        if (payload) {
            let result = [];
            for (let index = 0; index < payload.length; index++) {
                const element = payload[index];
                const dataresult = await this.repolet.findOne({ where: { id: element.redirectId } });
                if (dataresult) {
                    result.push({
                        id: element.id,
                        title: element.title,
                        desc: element.desc,
                        type: element.type,
                        redirectId: element.redirectId,
                        read: element.read,
                        createdAt: element.createdAt,
                        accountId: element.accountId,
                        account: element.account,
                        storeName: dataresult.storeName,
                    });
                }
                else {
                    result.push({
                        id: element.id,
                        title: element.title,
                        desc: element.desc,
                        type: element.type,
                        redirectId: element.redirectId,
                        read: element.read,
                        createdAt: element.createdAt,
                        accountId: element.accountId,
                        account: element.account,
                        storeName: 'None',
                    });
                }
            }
            return { result, total };
        }
        else {
            return { result: [], total };
        }
    }
    async update(id, accountId, status) {
        const notifications = await this.repo.findOne({ where: { id } });
        if (!notifications) {
            throw new common_1.NotFoundException('Notification not found!');
        }
        const obj = Object.assign(notifications, { read: status });
        return this.repo.save(obj);
    }
    async findReportAll(dto) {
        const fromDate = new Date(dto.fromDate);
        fromDate.setHours(0, 0, 0, 0);
        const toDate = new Date(dto.toDate);
        toDate.setHours(23, 59, 59, 999);
        const payloadtotal = await this.repo
            .createQueryBuilder('notification')
            .select([
            'notification.redirectId',
            'notification.accountId',
            'COUNT(notification.id) AS totalReq'
        ])
            .where('notification.type = :type and notification.createdAt >= :fromDate and notification.createdAt <= :toDate AND notification.accountId IS NULL', {
            type: enum_1.NotificationType.TIME_INCREMENT,
            fromDate: fromDate,
            toDate: toDate
        })
            .groupBy('notification.redirectId')
            .take(dto.limit)
            .skip(dto.offset)
            .getRawMany();
        const payloadapproved = await this.repo
            .createQueryBuilder('notification')
            .select([
            'notification.redirectId',
            'notification.accountId',
            'COUNT(notification.id) AS totalApproved'
        ])
            .where('notification.type = :type and notification.createdAt >= :fromDate and notification.createdAt <= :toDate AND notification.accountId IS NOT NULL', {
            type: enum_1.NotificationType.TIME_INCREMENT,
            fromDate: fromDate,
            toDate: toDate
        })
            .groupBy('notification.redirectId, notification.accountId')
            .take(dto.limit)
            .skip(dto.offset)
            .getRawMany();
        if (payloadtotal) {
            let result = [];
            for (let index = 0; index < payloadtotal.length; index++) {
                const totalreq = payloadtotal[index];
                const totalapproved = payloadapproved[index];
                const dataresult = await this.repolet.findOne({ where: { id: totalreq.notification_redirectId } });
                result.push({
                    storeName: dataresult.storeName,
                    totalReqCount: totalreq.totalReq,
                    totalApprovedCount: totalapproved.totalApproved,
                    totalPendingCount: totalreq.totalReq - totalapproved.totalApproved,
                });
            }
            return { result, 'total': result.length };
        }
        else {
            return { result: [], 'total': 0 };
        }
    }
};
NotificationsService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(notification_entity_1.Notification)),
    __param(1, (0, typeorm_1.InjectRepository)(outlet_detail_entity_1.OutletDetail)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository,
        axios_1.HttpService])
], NotificationsService);
exports.NotificationsService = NotificationsService;
//# sourceMappingURL=notifications.service.js.map