import { HttpService } from '@nestjs/axios';
import { Repository } from 'typeorm';
import { Notification } from './entities/notification.entity';
import { OutletDetail } from 'src/outlet-details/entities/outlet-detail.entity';
import { PaginationReportDto } from './dto/notification.dto';
export declare class NotificationsService {
    private readonly repo;
    private readonly repolet;
    private readonly httpService;
    constructor(repo: Repository<Notification>, repolet: Repository<OutletDetail>, httpService: HttpService);
    sendBulkNotification(body: any, title: any, token: any, status: any): Promise<any>;
    create(createDto: any): Promise<any>;
    findAll(limit: number, offset: number, accountId: string): Promise<{
        result: Notification[];
        total: number;
    }>;
    findAllForAdmin(limit: number, offset: number): Promise<{
        result: any[];
        total: number;
    }>;
    update(id: number, accountId: string, status: boolean): Promise<Notification & {
        read: boolean;
    }>;
    findReportAll(dto: PaginationReportDto): Promise<{
        result: any[];
        total: number;
    }>;
}
